<?php
/**
 * AJAX-Endpoint für Status-Updates
 */

require_once __DIR__ . '/../../includes/config.php';
require_once __DIR__ . '/../../includes/auth.php';
require_once __DIR__ . '/../../includes/database.php';
require_once __DIR__ . '/../../includes/functions.php';

init_session();

header('Content-Type: application/json');

// Login prüfen
if (!is_logged_in()) {
    http_response_code(401);
    echo json_encode(['error' => 'Nicht authentifiziert']);
    exit;
}

// Nur POST erlauben
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['error' => 'Methode nicht erlaubt']);
    exit;
}

// JSON-Body lesen
$input = json_decode(file_get_contents('php://input'), true);

if (!$input) {
    http_response_code(400);
    echo json_encode(['error' => 'Ungültige Anfrage']);
    exit;
}

// CSRF prüfen
if (!verify_csrf_token($input['csrf_token'] ?? '')) {
    http_response_code(403);
    echo json_encode(['error' => 'Ungültiges CSRF-Token']);
    exit;
}

$id = (int)($input['id'] ?? 0);
$status = $input['status'] ?? '';

if ($id <= 0) {
    http_response_code(400);
    echo json_encode(['error' => 'Ungültige ID']);
    exit;
}

$validStatuses = array_keys(get_all_statuses());
if (!in_array($status, $validStatuses)) {
    http_response_code(400);
    echo json_encode(['error' => 'Ungültiger Status']);
    exit;
}

// Update durchführen
$success = updateBestellung($id, [
    'status' => $status,
    'bearbeitet_von' => get_logged_in_user()
]);

if ($success) {
    app_log("Status von Bestellung #$id auf '$status' geändert von " . get_logged_in_user());
    echo json_encode([
        'success' => true,
        'message' => 'Status aktualisiert',
        'status' => $status,
        'status_label' => status_label($status)
    ]);
} else {
    http_response_code(500);
    echo json_encode(['error' => 'Fehler beim Speichern']);
}
