<?php
/**
 * Archiv: Liste aller erledigten/archivierten Bestellungen
 */

require_once __DIR__ . '/../includes/config.php';
require_once __DIR__ . '/../includes/auth.php';
require_once __DIR__ . '/../includes/database.php';
require_once __DIR__ . '/../includes/functions.php';

init_session();
require_login();

// Pagination
$page = max(1, (int)($_GET['page'] ?? 1));
$totalItems = countArchivedBestellungen();
$totalPages = max(1, ceil($totalItems / ITEMS_PER_PAGE));
$page = min($page, $totalPages);

// Archivierte Bestellungen laden
$bestellungen = getArchivedBestellungen($page);
?>
<!DOCTYPE html>
<html lang="de">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Archiv - Softwarebestellung Admin</title>
    <link rel="stylesheet" href="../public/css/style.css">
</head>
<body>
    <header class="admin-header">
        <h1>Archiv - Erledigte Bestellungen</h1>
        <div class="user-info">
            <a href="index.php">« Zurück zur Übersicht</a>
            <span>|</span>
            <span><?= h(get_logged_in_user()) ?></span>
            <a href="logout.php">Abmelden</a>
        </div>
    </header>

    <div class="admin-container">
        <?php if ($flash = get_flash()): ?>
            <div class="alert alert-<?= h($flash['type']) ?>">
                <?= h($flash['message']) ?>
            </div>
        <?php endif; ?>

        <div class="detail-card" style="margin-bottom: 20px;">
            <strong>Archivierte Bestellungen:</strong> <?= $totalItems ?>
        </div>

        <?php if (empty($bestellungen)): ?>
            <div class="alert alert-info">Keine archivierten Bestellungen vorhanden.</div>
        <?php else: ?>
            <table class="data-table">
                <thead>
                    <tr>
                        <th>ID</th>
                        <th>Erstellt</th>
                        <th>Archiviert</th>
                        <th>Schule</th>
                        <th>Software</th>
                        <th>Version</th>
                        <th>Archiviert von</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($bestellungen as $b): ?>
                        <tr>
                            <td>#<?= h($b['id']) ?></td>
                            <td><?= format_date($b['erstellt_am'], 'd.m.Y') ?></td>
                            <td><?= format_date($b['archiviert_am'], 'd.m.Y') ?></td>
                            <td><?= h($b['schul_name']) ?></td>
                            <td><?= h($b['software_name']) ?></td>
                            <td><?= h($b['version']) ?></td>
                            <td><?= h($b['archiviert_von']) ?></td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>

            <?php if ($totalPages > 1): ?>
                <div class="pagination">
                    <?php if ($page > 1): ?>
                        <a href="?page=<?= $page - 1 ?>">« Zurück</a>
                    <?php endif; ?>

                    <?php for ($i = 1; $i <= $totalPages; $i++): ?>
                        <?php if ($i === $page): ?>
                            <span class="current"><?= $i ?></span>
                        <?php else: ?>
                            <a href="?page=<?= $i ?>"><?= $i ?></a>
                        <?php endif; ?>
                    <?php endfor; ?>

                    <?php if ($page < $totalPages): ?>
                        <a href="?page=<?= $page + 1 ?>">Weiter »</a>
                    <?php endif; ?>
                </div>
            <?php endif; ?>
        <?php endif; ?>
    </div>
</body>
</html>
