<?php
/**
 * Bestellung als erledigt markieren und archivieren
 */

require_once __DIR__ . '/../includes/config.php';
require_once __DIR__ . '/../includes/auth.php';
require_once __DIR__ . '/../includes/database.php';
require_once __DIR__ . '/../includes/functions.php';

init_session();
require_login();

$id = (int)($_GET['id'] ?? 0);
if ($id <= 0) {
    set_flash('Ungültige Bestellungs-ID.', 'error');
    header('Location: index.php');
    exit;
}

$bestellung = getBestellung($id);
if (!$bestellung) {
    set_flash('Bestellung nicht gefunden.', 'error');
    header('Location: index.php');
    exit;
}

// Nur gesendete oder abgelehnte Bestellungen können archiviert werden
if (!in_array($bestellung['status'], ['gesendet', 'abgelehnt'])) {
    set_flash('Nur gesendete oder abgelehnte Bestellungen können archiviert werden.', 'error');
    header('Location: detail.php?id=' . $id);
    exit;
}

// Archivieren
if (archiveBestellung($id, get_logged_in_user())) {
    app_log("Bestellung #$id archiviert von " . get_logged_in_user());
    set_flash('Bestellung wurde als erledigt markiert und archiviert.', 'success');
    header('Location: index.php');
} else {
    set_flash('Fehler beim Archivieren.', 'error');
    header('Location: detail.php?id=' . $id);
}
exit;
