<?php
/**
 * Detailansicht & Bearbeitung einer Bestellung
 */

require_once __DIR__ . '/../includes/config.php';
require_once __DIR__ . '/../includes/auth.php';
require_once __DIR__ . '/../includes/database.php';
require_once __DIR__ . '/../includes/functions.php';

init_session();
require_login();

$id = (int)($_GET['id'] ?? 0);
if ($id <= 0) {
    set_flash('Ungültige Bestellungs-ID.', 'error');
    header('Location: index.php');
    exit;
}

// Bestellung laden
$bestellung = getBestellung($id);
if (!$bestellung) {
    set_flash('Bestellung nicht gefunden.', 'error');
    header('Location: index.php');
    exit;
}

// Formular-Verarbeitung
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (!verify_csrf_token($_POST['csrf_token'] ?? '')) {
        set_flash('Sicherheitsfehler. Bitte versuchen Sie es erneut.', 'error');
    } else {
        $updateData = [
            'schul_name' => trim($_POST['schul_name'] ?? ''),
            'software_name' => trim($_POST['software_name'] ?? ''),
            'version' => trim($_POST['version'] ?? ''),
            'hersteller' => trim($_POST['hersteller'] ?? ''),
            'hersteller_website' => trim($_POST['hersteller_website'] ?? ''),
            'isbn' => trim($_POST['isbn'] ?? '') ?: null,
            'software_quelle' => $_POST['software_quelle'] ?? '',
            'download_pfad' => trim($_POST['download_pfad'] ?? '') ?: null,
            'lizenz_typ' => $_POST['lizenz_typ'] ?? '',
            'lizenzschluessel' => trim($_POST['lizenzschluessel'] ?? '') ?: null,
            'lizenzserver_anmerkungen' => trim($_POST['lizenzserver_anmerkungen'] ?? '') ?: null,
            'status' => $_POST['status'] ?? $bestellung['status'],
            'notizen' => trim($_POST['notizen'] ?? '') ?: null,
            'bearbeitet_von' => get_logged_in_user()
        ];

        if (updateBestellung($id, $updateData)) {
            set_flash('Bestellung erfolgreich aktualisiert.', 'success');
            app_log("Bestellung #$id aktualisiert von " . get_logged_in_user());
            // Bestellung neu laden
            $bestellung = getBestellung($id);
        } else {
            set_flash('Fehler beim Speichern.', 'error');
        }
    }
}

// Historie laden
$historie = getHistorie($id);
?>
<!DOCTYPE html>
<html lang="de">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Bestellung #<?= h($bestellung['id']) ?> - Admin</title>
    <link rel="stylesheet" href="../public/css/style.css">
</head>
<body>
    <header class="admin-header">
        <h1>Bestellung #<?= h($bestellung['id']) ?></h1>
        <div class="user-info">
            <a href="index.php">« Zurück zur Übersicht</a>
            <span>|</span>
            <span><?= h(get_logged_in_user()) ?></span>
            <a href="logout.php">Abmelden</a>
        </div>
    </header>

    <div class="admin-container">
        <?php if ($flash = get_flash()): ?>
            <div class="alert alert-<?= h($flash['type']) ?>">
                <?= h($flash['message']) ?>
            </div>
        <?php endif; ?>

        <form method="POST">
            <?= csrf_field() ?>

            <!-- Metadaten -->
            <div class="detail-card">
                <h2>Status & Metadaten</h2>

                <div class="detail-row">
                    <div class="detail-label">Status</div>
                    <div class="detail-value">
                        <select name="status" style="padding: 8px; border-radius: 6px; border: 2px solid #e0e0e0;">
                            <?php foreach (get_all_statuses() as $key => $label): ?>
                                <option value="<?= h($key) ?>" <?= $bestellung['status'] === $key ? 'selected' : '' ?>>
                                    <?= h($label) ?>
                                </option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                </div>

                <div class="detail-row">
                    <div class="detail-label">Erstellt am</div>
                    <div class="detail-value"><?= format_date($bestellung['erstellt_am']) ?></div>
                </div>

                <div class="detail-row">
                    <div class="detail-label">Zuletzt bearbeitet</div>
                    <div class="detail-value">
                        <?= format_date($bestellung['bearbeitet_am']) ?>
                        <?php if ($bestellung['bearbeitet_von']): ?>
                            von <?= h($bestellung['bearbeitet_von']) ?>
                        <?php endif; ?>
                    </div>
                </div>
            </div>

            <!-- Schule -->
            <div class="detail-card">
                <h2>Schule</h2>
                <div class="form-group">
                    <label for="schul_name">Name der Schule *</label>
                    <input type="text" id="schul_name" name="schul_name"
                           value="<?= h($bestellung['schul_name']) ?>" required>
                </div>
            </div>

            <!-- Grundinformationen -->
            <div class="detail-card">
                <h2>Grundinformationen</h2>

                <div class="form-group">
                    <label for="software_name">Name der Software *</label>
                    <input type="text" id="software_name" name="software_name"
                           value="<?= h($bestellung['software_name']) ?>" required>
                </div>

                <div class="form-group">
                    <label for="version">Versionsnummer *</label>
                    <input type="text" id="version" name="version"
                           value="<?= h($bestellung['version']) ?>" required>
                </div>

                <div class="form-group">
                    <label for="hersteller">Hersteller *</label>
                    <input type="text" id="hersteller" name="hersteller"
                           value="<?= h($bestellung['hersteller']) ?>" required>
                </div>

                <div class="form-group">
                    <label for="hersteller_website">Hersteller-Website *</label>
                    <input type="url" id="hersteller_website" name="hersteller_website"
                           value="<?= h($bestellung['hersteller_website']) ?>" required>
                </div>

                <div class="form-group">
                    <label for="isbn">ISBN</label>
                    <input type="text" id="isbn" name="isbn"
                           value="<?= h($bestellung['isbn']) ?>">
                </div>
            </div>

            <!-- Bezug der Software -->
            <div class="detail-card">
                <h2>Bezug der Software</h2>

                <div class="form-group">
                    <label for="software_quelle">Bezugsquelle *</label>
                    <select id="software_quelle" name="software_quelle" required>
                        <option value="downloadFree" <?= $bestellung['software_quelle'] === 'downloadFree' ? 'selected' : '' ?>>
                            Kostenfreier Download
                        </option>
                        <option value="downloadCustomer" <?= $bestellung['software_quelle'] === 'downloadCustomer' ? 'selected' : '' ?>>
                            Download vom Kundenserver
                        </option>
                        <option value="physicalMedia" <?= $bestellung['software_quelle'] === 'physicalMedia' ? 'selected' : '' ?>>
                            Datenträger
                        </option>
                    </select>
                </div>

                <div class="form-group">
                    <label for="download_pfad">Download-Pfad</label>
                    <input type="text" id="download_pfad" name="download_pfad"
                           value="<?= h($bestellung['download_pfad']) ?>">
                </div>
            </div>

            <!-- Lizenzierung -->
            <div class="detail-card">
                <h2>Lizenzierung</h2>

                <div class="form-group">
                    <label for="lizenz_typ">Lizenztyp *</label>
                    <select id="lizenz_typ" name="lizenz_typ" required>
                        <option value="noLicense" <?= $bestellung['lizenz_typ'] === 'noLicense' ? 'selected' : '' ?>>
                            Keine Lizenz notwendig
                        </option>
                        <option value="licenseKey" <?= $bestellung['lizenz_typ'] === 'licenseKey' ? 'selected' : '' ?>>
                            Lizenzschlüssel
                        </option>
                        <option value="licenseHardware" <?= $bestellung['lizenz_typ'] === 'licenseHardware' ? 'selected' : '' ?>>
                            Hardware-Dongle
                        </option>
                        <option value="licenseServer" <?= $bestellung['lizenz_typ'] === 'licenseServer' ? 'selected' : '' ?>>
                            Lizenzserver
                        </option>
                    </select>
                </div>

                <div class="form-group">
                    <label for="lizenzschluessel">Lizenzschlüssel</label>
                    <input type="text" id="lizenzschluessel" name="lizenzschluessel"
                           value="<?= h($bestellung['lizenzschluessel']) ?>">
                </div>

                <div class="form-group">
                    <label for="lizenzserver_anmerkungen">Lizenzserver-Anmerkungen</label>
                    <textarea id="lizenzserver_anmerkungen" name="lizenzserver_anmerkungen"
                              rows="3"><?= h($bestellung['lizenzserver_anmerkungen']) ?></textarea>
                </div>
            </div>

            <!-- Interne Notizen -->
            <div class="detail-card">
                <h2>Interne Notizen</h2>
                <div class="form-group">
                    <textarea id="notizen" name="notizen" rows="4"
                              placeholder="Hier können interne Anmerkungen hinterlassen werden..."><?= h($bestellung['notizen']) ?></textarea>
                </div>
            </div>

            <!-- Aktionen -->
            <div class="detail-card">
                <h2>Aktionen</h2>
                <div class="actions">
                    <button type="submit" class="btn-primary">Speichern</button>
                    <a href="generate_pdf.php?id=<?= h($bestellung['id']) ?>" class="btn-secondary" target="_blank">
                        PDF-Vorschau
                    </a>
                    <?php if (in_array($bestellung['status'], ['warte_auf_genehmigung', 'genehmigt'])): ?>
                        <a href="send_to_iserv.php?id=<?= h($bestellung['id']) ?>" class="btn-success"
                           onclick="return confirm('Bestellung genehmigen und E-Mail mit PDF an iServ senden?');">
                            Genehmigen & an iServ senden
                        </a>
                    <?php endif; ?>
                    <?php if (in_array($bestellung['status'], ['gesendet', 'abgelehnt'])): ?>
                        <a href="archive.php?id=<?= h($bestellung['id']) ?>" class="btn-primary"
                           onclick="return confirm('Bestellung archivieren?');"
                           style="background: #2e7d32;">
                            Archivieren
                        </a>
                    <?php endif; ?>
                    <?php if (!in_array($bestellung['status'], ['gesendet', 'erledigt'])): ?>
                        <a href="reject.php?id=<?= h($bestellung['id']) ?>" class="btn-danger"
                           onclick="return confirm('Bestellung wirklich ablehnen?');">
                            Ablehnen
                        </a>
                    <?php endif; ?>
                </div>
            </div>
        </form>

        <!-- Änderungshistorie -->
        <?php if (!empty($historie)): ?>
            <div class="detail-card">
                <h2>Änderungshistorie</h2>
                <div class="history-list">
                    <?php foreach ($historie as $h): ?>
                        <div class="history-item">
                            <div class="meta">
                                <?= format_date($h['aenderung_am']) ?>
                                <?php if ($h['aenderung_von']): ?>
                                    von <?= h($h['aenderung_von']) ?>
                                <?php endif; ?>
                            </div>
                            <div class="change">
                                <strong><?= h($h['feld']) ?>:</strong>
                                <span class="old-value"><?= h($h['alter_wert'] ?: '(leer)') ?></span>
                                →
                                <span class="new-value"><?= h($h['neuer_wert'] ?: '(leer)') ?></span>
                            </div>
                        </div>
                    <?php endforeach; ?>
                </div>
            </div>
        <?php endif; ?>
    </div>
</body>
</html>
