<?php
/**
 * Admin-Login (LDAP + lokaler Fallback)
 */

require_once __DIR__ . '/../includes/config.php';
require_once __DIR__ . '/../includes/auth.php';
require_once __DIR__ . '/../includes/functions.php';

init_session();

// Bereits eingeloggt? Weiter zur Übersicht
if (is_logged_in()) {
    header('Location: index.php');
    exit;
}

$error = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // CSRF-Prüfung
    if (!verify_csrf_token($_POST['csrf_token'] ?? '')) {
        $error = 'Sicherheitsfehler. Bitte versuchen Sie es erneut.';
    } else {
        $username = trim($_POST['username'] ?? '');
        $password = $_POST['password'] ?? '';

        $auth_result = authenticate($username, $password);

        if ($auth_result) {
            $_SESSION['authenticated'] = true;
            $_SESSION['username'] = $auth_result['username'];
            $_SESSION['auth_method'] = $auth_result['method'];
            $_SESSION['login_time'] = time();

            app_log("Login erfolgreich: {$username} via {$auth_result['method']}");

            header('Location: index.php');
            exit;
        } else {
            $error = 'Benutzername oder Passwort falsch.';
        }
    }
}
?>
<!DOCTYPE html>
<html lang="de">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Login - Softwarebestellung Admin</title>
    <link rel="stylesheet" href="../public/css/style.css">
</head>
<body>
    <div class="container">
        <div class="login-card">
            <h1>Admin-Login</h1>
            <p class="login-hint">
                <?php if (LDAP_ENABLED): ?>
                    Anmeldung mit LDAP- oder lokalem Admin-Account
                <?php else: ?>
                    Anmeldung mit lokalem Admin-Account
                <?php endif; ?>
            </p>

            <?php if ($error): ?>
                <div class="alert alert-error"><?= h($error) ?></div>
            <?php endif; ?>

            <?php if (isset($_SESSION['flash_message'])): ?>
                <div class="alert alert-info"><?= h($_SESSION['flash_message']) ?></div>
                <?php unset($_SESSION['flash_message']); ?>
            <?php endif; ?>

            <form method="POST">
                <?= csrf_field() ?>

                <div class="form-group">
                    <label for="username">Benutzername</label>
                    <input type="text" id="username" name="username" required autofocus
                           value="<?= h($_POST['username'] ?? '') ?>">
                </div>

                <div class="form-group">
                    <label for="password">Passwort</label>
                    <input type="password" id="password" name="password" required>
                </div>

                <div class="submit-section">
                    <button type="submit" class="btn-submit">Anmelden</button>
                </div>
            </form>
        </div>
    </div>
</body>
</html>
