<?php
/**
 * Bestellung ablehnen
 */

require_once __DIR__ . '/../includes/config.php';
require_once __DIR__ . '/../includes/auth.php';
require_once __DIR__ . '/../includes/database.php';
require_once __DIR__ . '/../includes/functions.php';

init_session();
require_login();

$id = (int)($_GET['id'] ?? 0);
if ($id <= 0) {
    set_flash('Ungültige Bestellungs-ID.', 'error');
    header('Location: index.php');
    exit;
}

$bestellung = getBestellung($id);
if (!$bestellung) {
    set_flash('Bestellung nicht gefunden.', 'error');
    header('Location: index.php');
    exit;
}

// Status auf abgelehnt setzen
if (updateBestellung($id, [
    'status' => 'abgelehnt',
    'bearbeitet_von' => get_logged_in_user()
])) {
    app_log("Bestellung #$id abgelehnt von " . get_logged_in_user());
    set_flash('Bestellung wurde abgelehnt.', 'success');
} else {
    set_flash('Fehler beim Ablehnen.', 'error');
}

header('Location: detail.php?id=' . $id);
exit;
