<?php
/**
 * Bestellung genehmigen und E-Mail an iServ senden mit PDF-Anhang
 */

require_once __DIR__ . '/../includes/config.php';
require_once __DIR__ . '/../includes/auth.php';
require_once __DIR__ . '/../includes/database.php';
require_once __DIR__ . '/../includes/functions.php';
require_once __DIR__ . '/../includes/email.php';
require_once __DIR__ . '/../includes/pdf_generator.php';

init_session();
require_login();

$id = (int)($_GET['id'] ?? 0);
if ($id <= 0) {
    set_flash('Ungültige Bestellungs-ID.', 'error');
    header('Location: index.php');
    exit;
}

$bestellung = getBestellung($id);
if (!$bestellung) {
    set_flash('Bestellung nicht gefunden.', 'error');
    header('Location: index.php');
    exit;
}

// Prüfen ob Status erlaubt (warte_auf_genehmigung oder genehmigt)
if (!in_array($bestellung['status'], ['warte_auf_genehmigung', 'genehmigt'])) {
    set_flash('E-Mail kann nur für wartende oder genehmigte Bestellungen versendet werden.', 'error');
    header('Location: detail.php?id=' . $id);
    exit;
}

try {
    // Zuerst Status auf "genehmigt" setzen (falls noch nicht)
    if ($bestellung['status'] === 'warte_auf_genehmigung') {
        updateBestellung($id, [
            'status' => 'genehmigt',
            'bearbeitet_von' => get_logged_in_user()
        ]);
        // Bestellung neu laden
        $bestellung = getBestellung($id);
    }

    // PDF generieren
    $pdfPath = generate_pdf($bestellung);

    if (!file_exists($pdfPath)) {
        throw new Exception('PDF konnte nicht erstellt werden.');
    }

    // E-Mail senden
    $success = send_iserv_email($bestellung, $pdfPath);

    if ($success) {
        // Status auf "gesendet" setzen
        updateBestellung($id, [
            'status' => 'gesendet',
            'bearbeitet_von' => get_logged_in_user()
        ]);

        app_log("Bestellung #$id genehmigt und an iServ gesendet von " . get_logged_in_user());
        set_flash('Bestellung wurde genehmigt und E-Mail erfolgreich an iServ gesendet.', 'success');
    } else {
        throw new Exception('E-Mail konnte nicht gesendet werden.');
    }
} catch (Exception $e) {
    error_log("Fehler beim Senden an iServ: " . $e->getMessage());
    set_flash('Fehler: ' . $e->getMessage(), 'error');
}

header('Location: detail.php?id=' . $id);
exit;
