<?php
/**
 * Zentrale Konfigurationsdatei für das Softwarebestell-System
 */

// Fehlerbehandlung
error_reporting(E_ALL);
ini_set('display_errors', '1');  // In Produktion auf '0' setzen!
ini_set('log_errors', '1');
ini_set('error_log', __DIR__ . '/../data/logs/php_errors.log');

// Timezone
date_default_timezone_set('Europe/Berlin');

// Datenbank (PostgreSQL)
define('DB_TYPE', 'pgsql');           // 'pgsql' oder 'mysql'
define('DB_HOST', '127.0.0.1');
define('DB_PORT', '5432');            // 3306 für MySQL
define('DB_NAME', 'softwarebestellung');
define('DB_USER', 'softwarebestellung_user');
define('DB_PASS', 'SwBestellung2025');

// LDAP-Einstellungen
define('LDAP_ENABLED', false);        // false = nur lokaler Login (LDAP noch nicht konfiguriert)
define('LDAP_SERVER', 'ldap://iserv.example.com');
define('LDAP_PORT', 389);
define('LDAP_BASE_DN', 'ou=users,dc=iserv,dc=example,dc=com');
define('LDAP_BIND_DN', 'uid=%username%,ou=users,dc=iserv,dc=example,dc=com');

// Optional: Gruppen-basierte Berechtigung
define('LDAP_USE_GROUP_CHECK', false);
define('LDAP_ADMIN_GROUP', 'cn=it-admins,ou=groups,dc=iserv,dc=example,dc=com');

// Lokaler Admin (Fallback für Entwicklung/Notfall)
define('LOCAL_ADMIN_ENABLED', true);
define('LOCAL_ADMIN_USER', 'admin');
// Hash generieren mit: php -r "echo password_hash('dein_passwort', PASSWORD_BCRYPT);"
define('LOCAL_ADMIN_PASS_HASH', '$2y$10$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi'); // Standard: "password"

// E-Mail (SMTP)
define('SMTP_HOST', 'smtp.strato.de');
define('SMTP_PORT', 587);
define('SMTP_USER', 'iserv-test@eblok.de');
define('SMTP_PASS', 'DId01EzZcjpL9cGgfTCm');
define('SMTP_SECURE', 'tls');         // 'tls' oder 'ssl'
define('SMTP_FROM_EMAIL', 'iserv-test@eblok.de');
define('SMTP_FROM_NAME', 'Softwarebestell-System');

// E-Mail-Adressen
define('MAIL_TICKET_TO', 'ticket-test@eblok.de');
define('MAIL_ISERV_TO', 'iserv-test@eblok.de');
define('MAIL_COPY_TO', '');  // Kopieempfänger (CC) für iServ-E-Mails (leer = kein CC)

// Firmenname (wird im Formular und PDF angezeigt)
define('COMPANY_NAME', 'Ihre Organisation');

// E-Mail-Templates
// Platzhalter: {id}, {software_name}, {version}, {schul_name}, {hersteller}, {datum}, {admin_link}
define('MAIL_TEMPLATE_TICKET_SUBJECT', 'Neue Softwarebestellung #{id}: {software_name} - {schul_name}');
define('MAIL_TEMPLATE_TICKET_BODY', 'Eine neue Softwarebestellung ist eingegangen:

Bestell-ID: #{id}
Schule: {schul_name}
Software: {software_name} v{version}
Hersteller: {hersteller}
Status: Warte auf Genehmigung

Erstellt am: {datum}

Link zur Bearbeitung:
{admin_link}

Bitte prüfen und genehmigen Sie die Bestellung.');

define('MAIL_TEMPLATE_ISERV_SUBJECT', 'Softwarepaketierung: {software_name} v{version}');
define('MAIL_TEMPLATE_ISERV_BODY', 'Sehr geehrtes iServ-Team,

anbei finden Sie die ausgefüllten Informationen für ein neues Softwarepaket.

Software: {software_name}
Version: {version}
Schule: {schul_name}
Hersteller: {hersteller}

Bei Rückfragen stehen wir Ihnen gerne zur Verfügung.

Mit freundlichen Grüßen
{company_name}');

// Pfade
define('BASE_PATH', dirname(__DIR__) . '/');
define('PUBLIC_PATH', BASE_PATH . 'public/');
define('ADMIN_PATH', BASE_PATH . 'admin/');
define('DATA_PATH', BASE_PATH . 'data/');
define('PDF_PATH', DATA_PATH . 'pdfs/');
define('LOG_PATH', DATA_PATH . 'logs/');
define('FPDF_PATH', '/var/www/html/fpdf186/');

// URLs (anpassen für Produktionsumgebung)
define('BASE_URL', '/softwarebestellung');
define('ADMIN_URL', BASE_URL . '/admin');
define('PUBLIC_URL', BASE_URL . '/public');

// Sonstiges
define('PDF_RETENTION_DAYS', 7);      // PDFs nach 7 Tagen löschen
define('SESSION_TIMEOUT', 1800);      // 30 Minuten
define('ITEMS_PER_PAGE', 20);         // Bestellungen pro Seite

// Session-Konfiguration
ini_set('session.cookie_httponly', 1);
// Secure-Cookie nur bei HTTPS aktivieren (automatische Erkennung)
$isHttps = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off')
        || (!empty($_SERVER['HTTP_X_FORWARDED_PROTO']) && $_SERVER['HTTP_X_FORWARDED_PROTO'] === 'https')
        || (!empty($_SERVER['SERVER_PORT']) && $_SERVER['SERVER_PORT'] == 443);
ini_set('session.cookie_secure', $isHttps ? 1 : 0);
ini_set('session.use_strict_mode', 1);

// CSRF-Token generieren (wird bei session_start() aufgerufen)
function init_session() {
    if (session_status() === PHP_SESSION_NONE) {
        session_start();
    }

    if (empty($_SESSION['csrf_token'])) {
        $_SESSION['csrf_token'] = bin2hex(random_bytes(32));
    }

    // Session-Timeout prüfen
    if (isset($_SESSION['login_time']) && (time() - $_SESSION['login_time'] > SESSION_TIMEOUT)) {
        session_destroy();
        session_start();
        $_SESSION['csrf_token'] = bin2hex(random_bytes(32));
    }
}
