<?php
/**
 * Öffentliches Formular für Softwarebestellungen
 * Design basierend auf Softwarebestellung-v2.htm
 */

require_once __DIR__ . '/../includes/config.php';
require_once __DIR__ . '/../includes/functions.php';

init_session();
?>
<!DOCTYPE html>
<html lang="de">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Softwarebestellung - iServ</title>
    <style>
        :root {
            --primary: #0066cc;
            --primary-dark: #004499;
            --accent: #ff6b35;
            --bg-light: #f8f9fa;
            --bg-white: #ffffff;
            --text-dark: #1a1a1a;
            --text-medium: #4a4a4a;
            --text-light: #6a6a6a;
            --border: #e0e0e0;
            --shadow: rgba(0, 0, 0, 0.08);
        }

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Work Sans', -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;
            background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%);
            color: var(--text-dark);
            line-height: 1.6;
            min-height: 100vh;
        }

        .container {
            max-width: 900px;
            margin: 0 auto;
            padding: 40px 20px;
        }

        .header {
            text-align: center;
            margin-bottom: 50px;
            animation: fadeInDown 0.6s ease-out;
        }

        .logo {
            width: 180px;
            height: auto;
            margin-bottom: 20px;
        }

        .header h1 {
            font-family: 'Space Mono', monospace;
            font-size: 2.2em;
            color: var(--primary);
            margin-bottom: 10px;
            font-weight: 700;
            letter-spacing: -0.5px;
        }

        .header h2 {
            font-size: 1.4em;
            color: var(--text-medium);
            font-weight: 400;
            margin-bottom: 10px;
        }

        .header p {
            color: var(--text-medium);
            font-size: 1.1em;
            font-weight: 300;
        }

        .header .info-link {
            display: inline-block;
            margin-top: 10px;
            color: var(--primary);
            text-decoration: none;
            font-size: 0.9em;
            transition: color 0.3s;
        }

        .header .info-link:hover {
            color: var(--primary-dark);
        }

        .form-card {
            background: var(--bg-white);
            border-radius: 16px;
            box-shadow: 0 10px 40px var(--shadow);
            padding: 50px;
            animation: fadeInUp 0.8s ease-out;
        }

        .verification-box {
            background: linear-gradient(135deg, #fff3e0 0%, #ffe0b2 100%);
            border-left: 4px solid var(--accent);
            padding: 20px;
            border-radius: 8px;
            margin-bottom: 40px;
        }

        .verification-box label {
            display: flex;
            align-items: flex-start;
            cursor: pointer;
            font-weight: 400;
            color: var(--text-dark);
        }

        .verification-box input[type="checkbox"] {
            margin-right: 12px;
            margin-top: 3px;
            width: 20px;
            height: 20px;
            cursor: pointer;
            accent-color: var(--accent);
            flex-shrink: 0;
        }

        .form-section {
            margin-bottom: 45px;
            animation: fadeIn 1s ease-out;
        }

        .form-section h2 {
            font-family: 'Space Mono', monospace;
            font-size: 1.4em;
            color: var(--primary);
            margin-bottom: 25px;
            padding-bottom: 12px;
            border-bottom: 2px solid var(--primary);
            font-weight: 700;
        }

        .form-group {
            margin-bottom: 25px;
        }

        .form-group label {
            display: block;
            font-weight: 600;
            color: var(--text-dark);
            margin-bottom: 8px;
            font-size: 0.95em;
        }

        .form-group input[type="text"],
        .form-group input[type="url"],
        .form-group textarea {
            width: 100%;
            padding: 12px 16px;
            border: 2px solid var(--border);
            border-radius: 8px;
            font-family: 'Work Sans', sans-serif;
            font-size: 1em;
            transition: all 0.3s;
            background: var(--bg-light);
        }

        .form-group input:focus,
        .form-group textarea:focus {
            outline: none;
            border-color: var(--primary);
            background: var(--bg-white);
            box-shadow: 0 0 0 3px rgba(0, 102, 204, 0.1);
        }

        .form-group textarea {
            resize: vertical;
            min-height: 100px;
        }

        .radio-group {
            display: flex;
            flex-direction: column;
            gap: 15px;
        }

        .radio-option {
            display: flex;
            align-items: flex-start;
            padding: 16px;
            background: var(--bg-light);
            border-radius: 8px;
            transition: all 0.3s;
            cursor: pointer;
            border: 2px solid transparent;
        }

        .radio-option:hover {
            background: #e3f2fd;
            border-color: var(--primary);
        }

        .radio-option input[type="radio"] {
            margin-right: 12px;
            margin-top: 3px;
            width: 18px;
            height: 18px;
            cursor: pointer;
            accent-color: var(--primary);
            flex-shrink: 0;
        }

        .radio-option > div {
            flex: 1;
        }

        .radio-option label {
            cursor: pointer;
            color: var(--text-dark);
            flex: 1;
        }

        .radio-option input[type="text"],
        .radio-option textarea {
            margin-top: 8px;
            width: 100%;
        }

        .nested-input {
            margin-left: 30px;
            margin-top: 12px;
        }

        .submit-section {
            margin-top: 50px;
            text-align: center;
        }

        .btn-submit {
            background: linear-gradient(135deg, var(--primary) 0%, var(--primary-dark) 100%);
            color: white;
            border: none;
            padding: 16px 50px;
            font-size: 1.1em;
            font-weight: 600;
            border-radius: 50px;
            cursor: pointer;
            transition: all 0.3s;
            font-family: 'Space Mono', monospace;
            box-shadow: 0 4px 15px rgba(0, 102, 204, 0.3);
            text-transform: uppercase;
            letter-spacing: 1px;
        }

        .btn-submit:hover {
            transform: translateY(-2px);
            box-shadow: 0 6px 20px rgba(0, 102, 204, 0.4);
        }

        .btn-submit:active {
            transform: translateY(0);
        }

        .alert {
            padding: 15px 20px;
            border-radius: 8px;
            margin-bottom: 20px;
            font-weight: 500;
        }

        .alert-success {
            background: #d4edda;
            color: #155724;
            border: 1px solid #c3e6cb;
        }

        .alert-error {
            background: #f8d7da;
            color: #721c24;
            border: 1px solid #f5c6cb;
        }

        .section-hint {
            color: var(--text-light);
            margin-bottom: 20px;
            font-size: 0.9em;
        }

        @keyframes fadeInDown {
            from {
                opacity: 0;
                transform: translateY(-30px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }

        @keyframes fadeInUp {
            from {
                opacity: 0;
                transform: translateY(30px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }

        @keyframes fadeIn {
            from { opacity: 0; }
            to { opacity: 1; }
        }

        @media (max-width: 768px) {
            .container {
                padding: 20px 15px;
            }

            .form-card {
                padding: 30px 20px;
            }

            .header h1 {
                font-size: 1.8em;
            }

            .btn-submit {
                width: 100%;
                padding: 14px 30px;
            }
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <?php if (file_exists($_SERVER['DOCUMENT_ROOT'] . '/logo.png')): ?>
                <img src="/logo.png" alt="Logo" class="logo">
            <?php endif; ?>
            <h1><?= h(defined('COMPANY_NAME') ? COMPANY_NAME : 'Softwarebestellung') ?></h1>
            <h2>Neue Softwarepakete</h2>
            <p>Angaben zur Erstellung eines neuen Softwarepaketes</p>
        </div>

        <?php if ($flash = get_flash()): ?>
            <div class="alert alert-<?= h($flash['type']) ?>">
                <?= $flash['message'] ?>
            </div>
        <?php endif; ?>

        <form class="form-card" id="softwareForm" action="<?= PUBLIC_URL ?>/submit.php" method="POST">
            <?= csrf_field() ?>

            <div class="verification-box">
                <label>
                    <input type="checkbox" name="verified" required>
                    <span>Ich habe geprüft, dass die Software noch nicht von IServ paketiert wurde.<br>
                    <a href="https://iserv.eu/deploy/software" target="_blank" class="info-link">
                        → Liste aller vorhandenen iServ-Softwarepakete ansehen
                    </a></span>
                </label>
            </div>

            <div class="form-group">
                <label for="schulName">Name der Schule *</label>
                <input type="text" id="schulName" name="schulName" required>
            </div>

            <div class="form-section">
                <h2>Grundinformationen</h2>

                <div class="form-group">
                    <label for="softwareName">Name der Software *</label>
                    <input type="text" id="softwareName" name="softwareName" required>
                </div>

                <div class="form-group">
                    <label for="version">Versionsnummer *</label>
                    <input type="text" id="version" name="version" required>
                </div>

                <div class="form-group">
                    <label for="manufacturer">Hersteller *</label>
                    <input type="text" id="manufacturer" name="manufacturer" required>
                </div>

                <div class="form-group">
                    <label for="website">Hersteller-Website *</label>
                    <input type="url" id="website" name="website" placeholder="https://..." required>
                </div>

                <div class="form-group">
                    <label for="isbn">ISBN (sinnvoll für Lernsoftware)</label>
                    <input type="text" id="isbn" name="isbn">
                </div>
            </div>

            <div class="form-section">
                <h2>Bezug der Software</h2>

                <div class="radio-group">
                    <div class="radio-option">
                        <input type="radio" id="downloadFree" name="softwareSource" value="downloadFree" required>
                        <div>
                            <label for="downloadFree">Kostenfreier Download über Herstellerseite (ohne Registrierung)</label>
                            <input type="text" class="nested-input" id="downloadFreePath" name="downloadFreePath" placeholder="Pfad zur Datei angeben">
                        </div>
                    </div>

                    <div class="radio-option">
                        <input type="radio" id="downloadCustomer" name="softwareSource" value="downloadCustomer">
                        <div>
                            <label for="downloadCustomer">Bereitstellung als Download vom Kundenserver</label>
                            <input type="text" class="nested-input" id="downloadCustomerPath" name="downloadCustomerPath" placeholder="Pfad zur Datei angeben">
                        </div>
                    </div>

                    <div class="radio-option">
                        <input type="radio" id="physicalMedia" name="softwareSource" value="physicalMedia">
                        <label for="physicalMedia">Software wird auf Datenträger bereitgestellt</label>
                    </div>
                </div>
            </div>

            <div class="form-section">
                <h2>Lizenzierung der Software</h2>
                <p class="section-hint">
                    Lizenzinformationen sind für IServ zum Testen der Paketierung zwingend erforderlich
                </p>

                <div class="radio-group">
                    <div class="radio-option">
                        <input type="radio" id="noLicense" name="licenseType" value="noLicense" required>
                        <label for="noLicense">Keine Lizenz notwendig</label>
                    </div>

                    <div class="radio-option">
                        <input type="radio" id="licenseKey" name="licenseType" value="licenseKey">
                        <div>
                            <label for="licenseKey">Lizenzschlüssel</label>
                            <input type="text" class="nested-input" id="licenseKeyValue" name="licenseKeyValue" placeholder="Lizenzschlüssel eingeben">
                        </div>
                    </div>

                    <div class="radio-option">
                        <input type="radio" id="licenseHardware" name="licenseType" value="licenseHardware">
                        <label for="licenseHardware">Lizenz wird als Hardware bereitgestellt (z. B. Dongle)</label>
                    </div>

                    <div class="radio-option">
                        <input type="radio" id="licenseServer" name="licenseType" value="licenseServer">
                        <div>
                            <label for="licenseServer">Lizenzserver wird benötigt (voraussichtlich höherer Entwicklungsaufwand)</label>
                            <textarea class="nested-input" id="licenseServerNotes" name="licenseServerNotes" placeholder="Anmerkungen zum Lizenzserver" rows="4"></textarea>
                        </div>
                    </div>
                </div>
            </div>

            <div class="submit-section">
                <button type="submit" class="btn-submit">Formular absenden</button>
            </div>
        </form>
    </div>

    <script>
        // Dynamisches Ein-/Ausblenden von abhängigen Eingabefeldern
        document.querySelectorAll('input[name="softwareSource"]').forEach(radio => {
            radio.addEventListener('change', function() {
                // Alle nested inputs in dieser Gruppe deaktivieren
                document.querySelectorAll('input[name="softwareSource"]').forEach(r => {
                    const container = r.closest('.radio-option');
                    const nestedInputs = container.querySelectorAll('.nested-input');
                    nestedInputs.forEach(input => {
                        input.disabled = true;
                        input.style.opacity = '0.5';
                    });
                });

                // Aktives Feld aktivieren
                const container = this.closest('.radio-option');
                const nestedInputs = container.querySelectorAll('.nested-input');
                nestedInputs.forEach(input => {
                    input.disabled = false;
                    input.style.opacity = '1';
                });
            });
        });

        document.querySelectorAll('input[name="licenseType"]').forEach(radio => {
            radio.addEventListener('change', function() {
                // Alle nested inputs deaktivieren
                document.getElementById('licenseKeyValue').disabled = true;
                document.getElementById('licenseKeyValue').style.opacity = '0.5';
                document.getElementById('licenseServerNotes').disabled = true;
                document.getElementById('licenseServerNotes').style.opacity = '0.5';

                // Relevantes Feld aktivieren
                if (this.value === 'licenseKey') {
                    document.getElementById('licenseKeyValue').disabled = false;
                    document.getElementById('licenseKeyValue').style.opacity = '1';
                } else if (this.value === 'licenseServer') {
                    document.getElementById('licenseServerNotes').disabled = false;
                    document.getElementById('licenseServerNotes').style.opacity = '1';
                }
            });
        });

        // Initial alle nested inputs deaktivieren
        document.querySelectorAll('.nested-input').forEach(input => {
            input.disabled = true;
            input.style.opacity = '0.5';
        });
    </script>
</body>
</html>
