/**
 * Formular-Interaktionen
 */

document.addEventListener('DOMContentLoaded', function() {
    // Software-Quelle: Abhängige Felder ein/ausblenden
    const sourceRadios = document.querySelectorAll('input[name="softwareSource"]');
    const downloadFreePath = document.getElementById('downloadFreePath');
    const downloadCustomerPath = document.getElementById('downloadCustomerPath');

    function updateSourceFields() {
        const selected = document.querySelector('input[name="softwareSource"]:checked');

        // Alle Pfad-Felder deaktivieren
        if (downloadFreePath) {
            downloadFreePath.disabled = true;
            downloadFreePath.style.opacity = '0.5';
        }
        if (downloadCustomerPath) {
            downloadCustomerPath.disabled = true;
            downloadCustomerPath.style.opacity = '0.5';
        }

        // Gewähltes Feld aktivieren
        if (selected) {
            if (selected.value === 'downloadFree' && downloadFreePath) {
                downloadFreePath.disabled = false;
                downloadFreePath.style.opacity = '1';
                downloadFreePath.focus();
            } else if (selected.value === 'downloadCustomer' && downloadCustomerPath) {
                downloadCustomerPath.disabled = false;
                downloadCustomerPath.style.opacity = '1';
                downloadCustomerPath.focus();
            }
        }
    }

    sourceRadios.forEach(radio => {
        radio.addEventListener('change', updateSourceFields);
    });

    // Initial-Zustand
    updateSourceFields();

    // Lizenz-Typ: Abhängige Felder ein/ausblenden
    const licenseRadios = document.querySelectorAll('input[name="licenseType"]');
    const licenseKeyValue = document.getElementById('licenseKeyValue');
    const licenseServerNotes = document.getElementById('licenseServerNotes');

    function updateLicenseFields() {
        const selected = document.querySelector('input[name="licenseType"]:checked');

        // Alle Felder deaktivieren
        if (licenseKeyValue) {
            licenseKeyValue.disabled = true;
            licenseKeyValue.style.opacity = '0.5';
        }
        if (licenseServerNotes) {
            licenseServerNotes.disabled = true;
            licenseServerNotes.style.opacity = '0.5';
        }

        // Gewähltes Feld aktivieren
        if (selected) {
            if (selected.value === 'licenseKey' && licenseKeyValue) {
                licenseKeyValue.disabled = false;
                licenseKeyValue.style.opacity = '1';
                licenseKeyValue.focus();
            } else if (selected.value === 'licenseServer' && licenseServerNotes) {
                licenseServerNotes.disabled = false;
                licenseServerNotes.style.opacity = '1';
                licenseServerNotes.focus();
            }
        }
    }

    licenseRadios.forEach(radio => {
        radio.addEventListener('change', updateLicenseFields);
    });

    // Initial-Zustand
    updateLicenseFields();

    // Formular-Validierung vor Absenden
    const form = document.getElementById('softwareForm');
    if (form) {
        form.addEventListener('submit', function(e) {
            const verified = document.querySelector('input[name="verified"]');
            if (verified && !verified.checked) {
                e.preventDefault();
                alert('Bitte bestätigen Sie, dass die Software noch nicht von IServ paketiert wurde.');
                verified.focus();
                return false;
            }

            const source = document.querySelector('input[name="softwareSource"]:checked');
            if (!source) {
                e.preventDefault();
                alert('Bitte wählen Sie eine Bezugsquelle.');
                return false;
            }

            // Prüfen ob Download-Pfad angegeben wenn erforderlich
            if (source.value === 'downloadFree' && downloadFreePath && !downloadFreePath.value.trim()) {
                e.preventDefault();
                alert('Bitte geben Sie den Download-Pfad an.');
                downloadFreePath.focus();
                return false;
            }

            if (source.value === 'downloadCustomer' && downloadCustomerPath && !downloadCustomerPath.value.trim()) {
                e.preventDefault();
                alert('Bitte geben Sie den Download-Pfad an.');
                downloadCustomerPath.focus();
                return false;
            }

            const license = document.querySelector('input[name="licenseType"]:checked');
            if (!license) {
                e.preventDefault();
                alert('Bitte wählen Sie einen Lizenztyp.');
                return false;
            }

            // Prüfen ob Lizenzschlüssel angegeben wenn erforderlich
            if (license.value === 'licenseKey' && licenseKeyValue && !licenseKeyValue.value.trim()) {
                e.preventDefault();
                alert('Bitte geben Sie den Lizenzschlüssel ein.');
                licenseKeyValue.focus();
                return false;
            }

            return true;
        });
    }
});
