<?php
/**
 * Formular-Verarbeitung für neue Bestellungen
 */

require_once __DIR__ . '/../includes/config.php';
require_once __DIR__ . '/../includes/database.php';
require_once __DIR__ . '/../includes/functions.php';
require_once __DIR__ . '/../includes/email.php';

init_session();

// Nur POST-Requests erlauben
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    header('Location: index.php');
    exit;
}

// CSRF-Token prüfen
if (!verify_csrf_token($_POST['csrf_token'] ?? '')) {
    set_flash('Sicherheitsfehler: Ungültiges Token. Bitte versuchen Sie es erneut.', 'error');
    header('Location: index.php');
    exit;
}

// Validierung
$errors = validate_bestellung($_POST);

if (!empty($errors)) {
    set_flash(implode('<br>', $errors), 'error');
    header('Location: index.php');
    exit;
}

try {
    // Daten für Datenbank vorbereiten
    $data = prepare_bestellung_data($_POST);

    // In Datenbank speichern (mit Status 'warte_auf_genehmigung')
    $bestellungId = createBestellungWithStatus($data);

    if ($bestellungId) {
        // Ticket-E-Mail senden
        $emailSent = send_ticket_email($bestellungId, $data);

        app_log("Neue Bestellung erstellt: ID $bestellungId, Software: {$data['software_name']}, Schule: {$data['schul_name']}");

        if ($emailSent) {
            set_flash("Ihre Bestellung wurde erfolgreich übermittelt! Bestellnummer: #$bestellungId", 'success');
        } else {
            set_flash("Ihre Bestellung wurde gespeichert (Bestellnummer: #$bestellungId), aber die Benachrichtigung konnte nicht gesendet werden.", 'warning');
        }
    } else {
        throw new Exception("Bestellung konnte nicht gespeichert werden.");
    }
} catch (Exception $e) {
    error_log("Fehler bei Bestellung: " . $e->getMessage());
    set_flash('Ein Fehler ist aufgetreten. Bitte versuchen Sie es später erneut.', 'error');
}

header('Location: index.php');
exit;
