-- MySQL-Schema für Softwarebestell-System

-- Bestellungen Haupttabelle
CREATE TABLE bestellungen (
    id INT AUTO_INCREMENT PRIMARY KEY,
    schul_name VARCHAR(255) NOT NULL,
    status ENUM('neu', 'in_pruefung', 'korrektur_notwendig', 'genehmigt', 'abgelehnt', 'versendet') DEFAULT 'neu',

    -- Software-Daten
    software_name VARCHAR(255) NOT NULL,
    version VARCHAR(100) NOT NULL,
    hersteller VARCHAR(255) NOT NULL,
    hersteller_website VARCHAR(500) NOT NULL,
    isbn VARCHAR(50) DEFAULT NULL,

    -- Bezug
    software_quelle ENUM('downloadFree', 'downloadCustomer', 'physicalMedia') NOT NULL,
    download_pfad TEXT DEFAULT NULL,

    -- Lizenzierung
    lizenz_typ ENUM('noLicense', 'licenseKey', 'licenseHardware', 'licenseServer') NOT NULL,
    lizenzschluessel TEXT DEFAULT NULL,
    lizenzserver_anmerkungen TEXT DEFAULT NULL,

    -- Metadaten
    erstellt_am TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    bearbeitet_am TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    bearbeitet_von VARCHAR(100) DEFAULT NULL,
    notizen TEXT DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE INDEX idx_status ON bestellungen(status);
CREATE INDEX idx_schule ON bestellungen(schul_name);
CREATE INDEX idx_erstellt ON bestellungen(erstellt_am);
CREATE INDEX idx_software ON bestellungen(software_name);

-- Änderungshistorie
CREATE TABLE bestellungen_historie (
    id INT AUTO_INCREMENT PRIMARY KEY,
    bestellung_id INT NOT NULL,
    aenderung_von VARCHAR(100) DEFAULT NULL,
    aenderung_am TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    feld VARCHAR(100),
    alter_wert TEXT DEFAULT NULL,
    neuer_wert TEXT DEFAULT NULL,
    FOREIGN KEY (bestellung_id) REFERENCES bestellungen(id) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE INDEX idx_bestellung ON bestellungen_historie(bestellung_id);
CREATE INDEX idx_aenderung_am ON bestellungen_historie(aenderung_am);
