<?php
/**
 * Gemeinsamer Header für Admin-Seiten
 */
?>
<!DOCTYPE html>
<html lang="de">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= h($pageTitle ?? 'Admin') ?> - Softwarebestellung</title>
    <link rel="stylesheet" href="../public/css/style.css">
</head>
<body>
    <header class="admin-header">
        <h1><?= h($pageTitle ?? 'Softwarebestellung - Admin') ?></h1>
        <div class="user-info">
            <?php if (isset($showBackLink) && $showBackLink): ?>
                <a href="index.php">« Zurück zur Übersicht</a>
                <span>|</span>
            <?php endif; ?>
            <span>Angemeldet als: <?= h(get_logged_in_user()) ?></span>
            <a href="logout.php">Abmelden</a>
        </div>
    </header>

    <div class="admin-container">
        <?php if ($flash = get_flash()): ?>
            <div class="alert alert-<?= h($flash['type']) ?>">
                <?= h($flash['message']) ?>
            </div>
        <?php endif; ?>
