<?php
class PM {
  // Konstruktor
  public function __construct ($class_needed,$file_ending) {
    // Die Klasse wird eingebunden
      include($class_needed.$file_ending);
    // Es wird eine Instanz der Klasse erzeugt, und "class_obj" zugewiesen
      $this->class_obj = new $class_needed;
  }

  public function config($config, $MSG) {
    $this->msg = $MSG;
    $this->config = $config;
    ### Zeitstempel
    date_default_timezone_set("Europe/Berlin");

    $this->timestamp = time();
    $this->datum = date("Y.m.d",$this->timestamp);
    $this->uhrzeit = date("H-i-s",$this->timestamp);
    $this->zeit 	= $this->datum."--".$this->uhrzeit;
    $this->jahr 	= substr($this->zeit,0,4);
    $this->monat 	= substr($this->zeit,4,2);
    $this->tag 	= substr($this->zeit,6,2);
    $this->stunde = substr($this->zeit,8,2);
    $this->minute = substr($this->zeit,10,2);
    $this->del_older();
  }

  public function schreiben($msg) {
    echo "<div id=\"schreiben\">\n";
    // echo $this->msg['abschaltung'];
    echo "  <span id=\"text1\">$msg</span>\n";
    echo "  <form action=\"index.php?cont=eintragen\" method=\"post\">\n";
    echo "    <textarea name=\"text\" cols=\"40\" rows=\"10\"></textarea>\n<br/>\n";
    echo "    <input type=\"submit\" name=\"text_neu\" value=\"".$this->msg['link_erstellen']."\">\n";
    echo "  </form>\n";
    // echo "</div>\n";
  }

  public function eintragen($text) {
    #eintragen der Nachricht in DB
    $arr=array();
    $this->genCode($this->config['codelenght']);
    $this->text = $this->encrypt($text,$this->code);

    $arr[]=$this->code;
    $arr[]=$this->text;
    $arr[]=$this->timestamp;
    $arr[]="";
    if ($this->class_obj->insert("INSERT INTO nachrichten (rid,	msg, datum, rdatum) VALUES (?,?,?,?)", $arr)) {
        // $lastInsertId = $this->class_obj->lastInsertId();
        // $insertedRows = $this->class_obj->rowCount();
        echo"
        <div id=\"gespeichert\">\n";
        echo $this->msg['gespeichert1'];
          echo "
          <b><span id=\"hinweis\">".$this->msg['hinweis']."</span><br /><br />
          <!-- Target -->\n
          <span  id=\"foo\" >".$this->config['URL'].$this->code."</span><br />\n
          <!-- Trigger -->\n
          <div class=\"button_container\">\n
          <button class=\"btn\" data-clipboard-target=\"#foo\">\n
            <img src=\"assets/clippy.svg\" alt=\"".$this->msg['clipboard']."\">\n
          </button>\n
          </div>\n
          <script src=\"dist/clipboard.min.js\"></script>\n
          <script>\n
            new Clipboard('.btn');\n
          </script>\n

          <b></b><br /><br />\n
          <a href=\"index.php\">".$this->msg['link_weitere']."</a>\n
        </div>\n" ;
        $this->update_sqlcounter();
    }  else  {
        // $meldung = "Eintrag fehlerhaft!<br/>\n";
    }
    // return $meldung;
  }

  public function msg_zeigen($id) {
    $selected = $this->class_obj->select("SELECT id,rid,msg,datum,rdatum,gelesen FROM nachrichten WHERE rid = '$id' AND gelesen='0' ");
    $rowCount = $this->class_obj->rowCount();
    echo "<div id=\"anzeigen1\">\n";
    if (count($selected) > 0) {
      echo "<a href=\"index.php?idd=$id\">". $this->msg['neue_Nachricht']."</a>";
    } else {
      echo $this->msg['keine_Nachricht'];
    }
    $this->msg_link();
    echo "</div>\n";
  }

  public function msg_zeigen2($id) {


    //  $this->debug($id);
     $selected = $this->class_obj->select("SELECT id,rid,msg,datum,rdatum,gelesen FROM nachrichten WHERE rid = '$id' AND gelesen='0' ");
     $rowCount = $this->class_obj->rowCount();
     echo "<div id=\"anzeigen2\">\n";
     if (count($selected) > 0) {
       $this->class_obj->delete("DELETE FROM nachrichten WHERE id = ?", array($selected[0]['id']));
       echo "<h2>Deine Nachricht... </h2>";
       echo nl2br($this->decrypt($selected[0]['msg'], $id));

      // echo "<span id=\"counter\"></span>";
     } else {
       echo $this->msg['zu_spaet'];
     }
     $this->msg_link();
  }

  private function X_site_reload() {
    // Laufbalken und Reload zu Index.php
    echo"<hr /><a href=\"index.php\">Schlie&szlig;en</a> in <span id=\"counter\"></span> Sekunden<br />";
    echo "<div style=\"width:335px; border:0px solid #000; align:left;\"><img id=\"status\" src=\"spacer.gif\" width=\"10\" height=\"10\" style=\"background-color: #8080FF;\"></div>";
    // echo "<meta http-equiv=\"Refresh\" content=\"".$this->config['clientDelTime']."; url=index.php\">";
    echo "<script type=\"text/javascript\" language=\"JavaScript\">";
    echo "load(".$this->config['clientDelTime'].",0)";
    echo "</script>";
    echo "</div>\n";

  }

  public function alle_zeigen() {

    //  $this->debug($id);
     $selected = $this->class_obj->select("SELECT id,rid,msg,datum,rdatum,gelesen FROM nachrichten");
     $rowCount = $this->class_obj->rowCount();
     for ($i=0; $i < $rowCount; $i++) {
       if (count($selected) > 0) {
         echo nl2br($this->decrypt($selected[$i]['msg'], $selected[$i]['rid']))." - ".date("d.m.Y H:i:s", $selected[$i]['datum'])."<hr />";
       }
     }
     $this->msg_link();
  }

  public function del_older() {
     $selected = $this->class_obj->select("SELECT id,rid,msg,datum,rdatum,gelesen FROM nachrichten");
     $rowCount = $this->class_obj->rowCount();
     for ($i=0; $i < $rowCount; $i++) {
       if (count($selected) > 0) {
         if($selected[$i]['datum'] < strtotime("-".$this->config['userDelDays']." days")) {
           $this->class_obj->delete("DELETE FROM nachrichten WHERE id = ?", array($selected[$i]['id']));
         }
       }
     }
  }

  private function msg_link() {
     echo "<br /><br /><hr /><br /><a href=\"index.php\">".$this->msg['selbstNachricht']."</a><br /><br /><br />  ";

  }

  public function admin_sql($array, $typ) {
   $this->debug($array);
   $del = array_pop($array);
   foreach ($array as $key => $value) {
     #echo $key."-".$value."<br/>";
     $arr[] = $value;
   }
   switch ($typ) {
     case "config":
       #rsort($array);
       $this->debug($array);
       $this->class_obj->update("UPDATE ".$this->tabellen[4]." SET erinnerung=?,url=?  WHERE id = ? LIMIT 1", array($array['erinnerung'],$array['url'],$array['id']));
       $this->config($this->tabellen,$this->spalten,$this->farben);
     break;
     case "mail_del":
       $this->class_obj->delete("DELETE FROM ".$this->tabellen[3]." WHERE id = ". $arr[0]);
     break;

     case "mail_chg":
       $this->class_obj->update("UPDATE ".$this->tabellen[3]." SET adresse=?  WHERE id = ? LIMIT 1", array($arr[1],$arr[0]));
     break;

     case "mail_neu":
       $this->class_obj->insert("INSERT INTO ".$this->tabellen[3]." (adresse) VALUES (?)", $arr);
     break;

     case "bereich_del":
       $this->class_obj->delete("DELETE FROM ".$this->tabellen[0]." WHERE id = ". $arr[0]);
     break;

     case "bereich_chg":
       $this->class_obj->update("UPDATE ".$this->tabellen[0]." SET bezeichnung=?  WHERE id = ? LIMIT 1",
                 array($arr[1],$arr[0]));
     break;

     case "bereich_neu":
       $this->class_obj->insert("INSERT INTO ".$this->tabellen[0]." (bezeichnung) VALUES (?)", $arr);
     break;

     case "tage_del":
       $this->class_obj->delete("DELETE FROM ".$this->tabellen[1]." WHERE id = ". $arr[0]);
     break;

     case "tage_chg":
       $this->class_obj->update("UPDATE ".$this->tabellen[1]." SET bereich=?, bezeichnung=?,tage=? WHERE id = ? LIMIT 1",
                 array($arr[1],$arr[2],$arr[3],$arr[0]));
     break;

     case "tage_neu":
       $this->class_obj->insert("INSERT INTO ".$this->tabellen[1]." (bereich, bezeichnung, tage) VALUES (?,?,?)", $arr);
     break;
   }
  }

  private	function genCode($characters) {
    $possible = '1234567890abedefghijklmnopqrstuvwxyzABCDEFGHIJKLMNNOPQRSTUVWXYZ';
    $this->code = '';
    $i = 0;
    while ($i < $characters) {
      $this->code .= substr($possible, mt_rand(0, strlen($possible)-1), 1);
      $i++;
    }
    return $this->code;
  }

  private function encrypt($string, $code) {
    $result = '';
    $key=$this->config['salt'].$code;
    for($i = 0; $i < strlen($string); $i++) {
        $char = substr($string, $i, 1);
        $keychar = substr($key, ($i % strlen($key)) - 1, 1);
        $char = chr(ord($char) + ord($keychar));
        $result .= $char;
    }
    #echo "Ergebnis: ".$result."<br>";
    return base64_encode($result);
  }

  private function decrypt($string, $code) {
      $result = '';
      $string = base64_decode($string);
      $key=$this->config['salt'].$code;

      for($i = 0; $i < strlen($string); $i++) {
        	$char = substr($string, $i, 1);
        	$keychar = substr($key, ($i % strlen($key)) - 1, 1);
        	$char = chr(ord($char) - ord($keychar));
        	$result .= $char;
      }
      #echo $result."<br>";
      return $result;
  }

  private function update_sqlcounter() {
    $neuerwert=0;
    $wert = $this->sqlcounter();
    $neuerwert = $wert + 1;
        if ($this->class_obj->update("UPDATE sqlcounter SET sqlcounter=? WHERE id = ? ", array($neuerwert,1))) {
          $updatedRows = $this->class_obj->rowCount();
          $this->meldung=" wurde erfolgreich ge&auml;ndert.\n";
        } else {
          $this->meldung = "Beim &auml;ndern gab es einen Fehler.\n";
        }
      // echo $this->meldung;
    }


  private function update_webcounter() {
    // if ($this->class_obj->update("UPDATE sqlcounter SET sqlcounter=? WHERE id = ? ", array($neuerwert,0))) {
    //   $updatedRows = $this->class_obj->rowCount();
    //   $this->meldung=" wurde erfolgreich ge&auml;ndert.\n";
    // } else {
    //   $this->meldung = "Beim &auml;ndern gab es einen Fehler.\n";
    // }
    // echo $this->meldung;

      }

  public function sqlcounter() {  // 0 = counter, 1 = sqlcounter
    $counter = $this->class_obj->select("SELECT sqlcounter FROM sqlcounter WHERE id='1'");
    $this->sqlcounter = $counter[0]['sqlcounter'];
    return $this->sqlcounter ;
  }

  public function webcounter() {  // 0 = counter, 1 = sqlcounter
    $counter = $this->class_obj->select("SELECT counter FROM counter WHERE id='1'");
    $this->counter = $counter[0]['counter'];
    $this->debug($this->counter);
    return $this->counter ;
  }


  // ----------------------------------------------------------------------------

  public function update($version) {
    echo "<h2>Updates</h2>\n";
    $file = $this->read_dir("update/");
    rsort($file);
    $this->file = $file;
    #$this->debug($file);
    if ($version != "") {
      include("update/".$this->file[$version]);
      echo "<p>Update durchgef&uuml;hrt.</p>";
    } else {
      foreach ($this->file as $key => $value) {
        echo "<a href=\"index.php?cont=admin_update&version=".$key."\">".$value."</a><br>\n";
      }
    }
  }
  // ----------------------------------------------------------------------------

  private function select($typen, $name, $selected="",$default=0) {
    echo "<select size=\"1\" name=\"$name\">\n";
    if (isset($default)AND ($default==1)) { echo "<option  value=\"0\">alle zeigen</option>";}
    foreach ($typen as $typ => $key) {
      echo '<option ';
      if ($key['id'] == $selected) {
        echo " selected ";
      }
      echo "  value=\"".$key['id']."\">".$key['bezeichnung']."</option>\n";
    }
    echo "</select>\n";
  }

  private function read_dir($dir) {
    $handle=opendir($dir);
    while ($file=readdir($handle)){ ## Dir auslesen
      if($file!=".."  ){ ## wenn keine Ordner
        if (!is_dir($file)) {
          $testfile=substr($file,0,1);#echo "erster buchstabe ".$testfile." - $file<br>";
          if ($testfile != ".") { ## wenn die datei keinen punkt vor dem nadeinamen hat
            $gekuerzt = substr($file,-1);
            if ($gekuerzt !="~") {
              #echo "normal:$file - gekuerzt:$gekuerzt<br>";
              $functions[] = $file; #echo "$file<br>";
            }
          }
        }
      }
    }
    closedir($handle);
    return $functions;
  }

  private function debug ($ausgabe="", $array=true) {
  	if ($ausgabe !="") {
  		if (isset($_SESSION['debug']) and ($_SESSION['debug'] == true)) {
  			if (is_string($ausgabe)) { echo "<font color=\"#FF0000\">(".$ausgabe.")</font><br>\n"; }
          if (is_array($ausgabe)) {
    			  if ($array) {
    				  echo "<pre>\n";
    				  print_r($ausgabe);
    				  echo "</pre>\n";
    			  }
  				}

  		}
  	}
  }

// ----------------------------------------------------------------------------
// Klassen ende
}
?>
