<?php
class PM {

  public $class_obj;
  private $msg;
  private $config;
  private $timestamp;
  private $datum;
  private $uhrzeit;
  private $zeit;
  private $jahr;
  private $monat;
  private $tag;
  private $stunde;
  private $minute;
  private $sqlcounter;
  private $pwcounter;
  private $counter;
  private $text;
  private $code;
  private $meldung;

  // Konstruktor
  public function __construct ($class_needed,$file_ending) {
    // Die Klasse wird eingebunden
      include($class_needed.$file_ending);
    // Es wird eine Instanz der Klasse erzeugt, und "class_obj" zugewiesen
      $this->class_obj = new $class_needed;
      $this->debug($_POST);
      $this->debug($_GET);
  }

  public function config($config, $MSG) {
    $this->msg = $MSG;
    $this->config = $config;
    ### Zeitstempel
    date_default_timezone_set("Europe/Berlin");

    $this->timestamp = time();
    $this->datum = date("Y.m.d",$this->timestamp);
    $this->uhrzeit = date("H-i-s",$this->timestamp);
    $this->zeit 	= $this->datum."--".$this->uhrzeit;
    $this->jahr 	= substr($this->zeit,0,4);
    $this->monat 	= substr($this->zeit,4,2);
    $this->tag 	= substr($this->zeit,6,2);
    $this->stunde = substr($this->zeit,8,2);
    $this->minute = substr($this->zeit,10,2);
    $this->del_older();
  }

  public function schreiben($msg) {
    $typen=array("0"=>"0","1"=>"1","2"=>"2","3"=>"3", );
    echo "<div id=\"schreiben\">\n";
    echo "  <span id=\"text1\">$msg</span>\n";
    echo "  <form action=\"index.php?cont=eintragen\" method=\"post\">\n";
    echo "    <input type=\"hidden\" name=\"csrf_token\" value=\"" . htmlspecialchars($_SESSION['csrf_token'], ENT_QUOTES, 'UTF-8') . "\">\n";
    echo "    <textarea name=\"text\" cols=\"40\" rows=\"10\"></textarea>\n<br/><br />\n";
    echo "    <input type=\"submit\" name=\"text_neu\" value=\"".$this->msg['link_erstellen']."\"><br /><br />\n";
    echo "<hr />\n";
    echo "zus&auml;tzliche Optionen:<br /><br />\n";
    echo "<label for \"pw\">Passwort</label>  <input id=\"pw\" type=\"password\" name=\"passwort\" size=\"8\" />\n";
    echo "    <input id=\"check\" type=\"checkbox\" />\n";
    echo "<label for \"check\"> ".$this->msg['zeigen']."</label><br />\n";
    echo "<span id=\"passworthinweisSender\">".$this->msg['passworthinweisSender']."</span><br />\n";
    echo "<label for \"fehlversuche\">M&ouml;gliche Passwortfehlversuche des Empf&auml;nger erlauben.</label>\n";$this->select($typen, "fehlversuche",$this->config['Passwortfehlversuche']);
    echo "  </form>\n";
    echo "<script>\n";
    echo "	var check = document.getElementById(\"check\"),\n";
    echo "		pw = document.getElementById(\"pw\");\n";
    echo "	check.onclick = function() {\n";
    echo "		pw.type = this.checked ? \"text\" : \"password\";\n";
    echo "	};\n";
    echo "</script>\n";
    echo "\n";
    echo "</div>\n";
  }

  public function eintragen($text,$passwort,$fehlversuche) {
    $PW=0;
    #eintragen der Nachricht in DB
    $this->genCode($this->config['codelenght']);
    if($passwort != ""){
      $code=$this->code.$passwort;
      $PW=1;
      $this->update_pwcounter();
    } else {
      $code=$this->code;
      $PW=0;
    }
    $arr=array();
    $this->text = $this->encryptText($text,$code);
    $arr[]=$this->code;
    $arr[]=$this->text;
    $arr[]=$this->timestamp;
    $arr[]="";
    $arr[]=$PW;
    $arr[]=$fehlversuche;
    if ($this->class_obj->insert("INSERT INTO nachrichten (rid,	msg, datum, rdatum, passwort,fehler) VALUES (?,?,?,?,?,?)", $arr)) {
        $this->debug($arr);
        echo"
        <div id=\"gespeichert\">\n";
        echo $this->msg['gespeichert1'];
          echo "
          <b><span id=\"hinweis\">".$this->msg['hinweis']."</span><br /><br /></b>
          <!-- Target -->\n
          <div id=\"urlbox\">\n
            <span id=\"url\" >".$this->config['URL'].$this->code."</span><br />\n
          </div>\n
          <!-- Trigger -->\n
          <div class=\"button_container\">\n
          <button class=\"btn\" data-clipboard-target=\"#url\">\n
            <img src=\"assets/clippy.svg\" alt=\"".$this->msg['clipboard']."\">\n
          </button>\n
          </div>\n
          <script src=\"dist/clipboard.min.js\"></script>\n
          <script>\n
            new Clipboard('.btn');\n
          </script>\n

          <b></b><br /><br />\n
          <a href=\"index.php\">".$this->msg['link_weitere']."</a>\n
        </div>\n" ;
        $this->update_sqlcounter();
    }  else  {
        // $meldung = "Eintrag fehlerhaft!<br/>\n";
    }
  }

  public function msg_zeigen($id) {
    $selected = $this->class_obj->select("SELECT id,rid,passwort,fehler FROM nachrichten WHERE rid = ?", array($id));
    $rowCount = $this->class_obj->rowCount();
    $anzahlVersuche=array(
      0 => "<u>Du hast nur <b>diesen</b> Versuch.</u><br /><br />",
      1 => "<u>Du hast nur <b>einen</b> Versuch.</u><br /><br />",
      2 => "<u>Du hast nur <b>zwei</b> Versuche.</u><br /><br />",
      3 => "<u>Du hast nur <b>drei</b> Versuche.</u><br /><br />",
    );
    if(!isset($_SESSION['fehlversuche']) && isset($selected[0])) {$_SESSION['fehlversuche']=$selected[0]['fehler'];}
    $this->debug($rowCount);
    $this->debug($selected);
    echo "<div id=\"anzeigen1\">\n";
    if (count($selected) > 0) {
      if($selected[0]['passwort'] == "1") {
        $escapedId = htmlspecialchars($id, ENT_QUOTES, 'UTF-8');
        echo "<form action=\"index.php?idd=$escapedId\" method=\"post\">\n";
        echo "  <input type=\"hidden\" name=\"csrf_token\" value=\"" . htmlspecialchars($_SESSION['csrf_token'], ENT_QUOTES, 'UTF-8') . "\">\n";
        echo "  <span id=\"empfaengerhinweis\">".$this->msg['empfaengerhinweis']."</span>\n";
        echo "  <label for \"pw\">Passwort</label>  <input id=\"pw\" type=\"password\" name=\"passwort\" size=\"8\" />\n";
        echo "  <input id=\"check\" type=\"checkbox\" /><label for \"check\"> ".$this->msg['zeigen']."</label><br />\n";
        echo "  <span id=\"passworthinweis\">".$this->msg['passworthinweisEmpf']."</span><br />\n";
        echo $anzahlVersuche[$_SESSION['fehlversuche']];
        echo "  <input type=\"submit\" name=\"submit\" value=\"".$this->msg['zeigen']."\">\n";
        echo "</form>\n";
        echo "<script>\n";
        echo "	var check = document.getElementById(\"check\"),\n";
        echo "		pw = document.getElementById(\"pw\");\n";
        echo "	check.onclick = function() {\n";
        echo "		pw.type = this.checked ? \"text\" : \"password\";\n";
        echo "	};\n";
        echo "</script>\n";
      } else {
        echo "<a href=\"index.php?idd=" . htmlspecialchars($id, ENT_QUOTES, 'UTF-8') . "\">". $this->msg['neue_Nachricht']."</a>";
      }
    } else {
      echo $this->msg['keine_Nachricht'];
    }
    $this->msg_link();
    echo "</div>\n";
  }

  public function msg_zeigen2($id) {
     $selected = $this->class_obj->select("SELECT id,rid,msg,passwort FROM nachrichten WHERE rid = ?", array($id));
     $rowCount = $this->class_obj->rowCount();
     if (isset($_POST['passwort'])) {
       $pw=$id.$_POST['passwort'];
     } else {
       $pw=$id;
     }
     echo "<div id=\"anzeigen2\">\n";
     if (count($selected) > 0) {
       echo "<h2>Deine Nachricht... </h2>";
       $decrypted = $this->decryptText($selected[0]['msg'], $pw);
       if ($decrypted == null) {
         if( $_SESSION['fehlversuche'] >= 1) {
           $escapedId = htmlspecialchars($id, ENT_QUOTES, 'UTF-8');
           echo "Das Passwort war falsch.<br />Der Absender hat dir noch " . intval($_SESSION['fehlversuche']) . " Versuche erlaubt.<br />
           <br /><a href=\"index.php?id=$escapedId\">Nochmal eingeben.</a>\n";
           $_SESSION['fehlversuche']--;
         } else {
           echo "Das Passwort war falsch.<br />Der Absender hat dir keine <br />Passwort-Fehlversuche erlaubt.<br />Deshalb wurde die Nachricht gel&ouml;scht<br />";
           $this->class_obj->delete("DELETE FROM nachrichten WHERE id = ?", array($selected[0]['id']));
           session_destroy();
         }
       } else {
         echo nl2br(htmlspecialchars($decrypted, ENT_QUOTES, 'UTF-8'));
         $this->class_obj->delete("DELETE FROM nachrichten WHERE id = ?", array($selected[0]['id']));
         session_destroy();
       }
     } else {
       echo $this->msg['zu_spaet'];
     }
     $this->msg_link();
     echo "</div>\n";
  }

  public function alle_zeigen() {
     $selected = $this->class_obj->select("SELECT id,rid,msg,datum,rdatum,passwort FROM nachrichten");
     $rowCount = $this->class_obj->rowCount();
     for ($i=0; $i < $rowCount; $i++) {
       if (count($selected) > 0) {
         echo nl2br(htmlspecialchars($this->decryptText($selected[$i]['msg'], $selected[$i]['rid']), ENT_QUOTES, 'UTF-8'))." - ".date("d.m.Y H:i:s", $selected[$i]['datum'])."<hr />";
       }
     }
     $this->msg_link();
  }

  public function del_older() {
     $selected = $this->class_obj->select("SELECT id,rid,msg,datum,rdatum,passwort FROM nachrichten");
     $rowCount = $this->class_obj->rowCount();
     for ($i=0; $i < $rowCount; $i++) {
       if (count($selected) > 0) {
         if($selected[$i]['datum'] < strtotime("-".$this->config['userDelDays']." days")) {
           $this->class_obj->delete("DELETE FROM nachrichten WHERE id = ?", array($selected[$i]['id']));
         }
       }
     }
  }

  private function msg_link() {
     echo "<br /><br /><hr /><br /><a href=\"index.php\">".$this->msg['selbstNachricht']."</a><br /><br /><br />  ";
  }

  private	function genCode($characters) {
    $possible = '1234567890abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
    $this->code = '';
    $i = 0;
    while ($i < $characters) {
      $this->code .= $possible[random_int(0, strlen($possible)-1)];
      $i++;
    }
    return $this->code;
  }

  // NOTE: encryptText/decryptText verwenden kein HMAC (Integritaetspruefung).
  // Fuer neue Deployments sollte HMAC mit Versions-Flag ergaenzt werden.
  // Bestehende Nachrichten muessen mit dieser Methode entschluesselbar bleiben.

  // Funktion zur Verschluesselung des Textes
  private function encryptText($text, $password) {
      $method = 'AES-256-CBC';
      $key = openssl_digest($password, 'SHA256', true);
      $ivLength = openssl_cipher_iv_length($method);
      $iv = openssl_random_pseudo_bytes($ivLength);

      $encrypted = openssl_encrypt($text, $method, $key, OPENSSL_RAW_DATA, $iv);
      $ciphertext = $iv . $encrypted;

      return base64_encode($ciphertext);
  }

  // Funktion zur Entschluesselung des Textes
  private function decryptText($ciphertext, $password) {
      $method = 'AES-256-CBC';
      $key = openssl_digest($password, 'SHA256', true);
      $ivLength = openssl_cipher_iv_length($method);

      $ciphertext = base64_decode($ciphertext);
      $iv = substr($ciphertext, 0, $ivLength);
      $ciphertext = substr($ciphertext, $ivLength);

      $decrypted = openssl_decrypt($ciphertext, $method, $key, OPENSSL_RAW_DATA, $iv);

      return $decrypted;
  }

  private function update_sqlcounter() {
    $neuerwert=0;
    $wert = $this->sqlcounter();
    $neuerwert = $wert + 1;
        if ($this->class_obj->update("UPDATE sqlcounter SET sqlcounter=? WHERE id = ? ", array($neuerwert,1))) {
          $updatedRows = $this->class_obj->rowCount();
          $this->meldung=" wurde erfolgreich ge&auml;ndert.\n";
        } else {
          $this->meldung = "Beim &auml;ndern gab es einen Fehler.\n";
        }
    }

  private function update_pwcounter() {
    $neuerwert=0;
    $wert = $this->pwcounter();
    $neuerwert = $wert + 1;
        if ($this->class_obj->update("UPDATE pwcounter SET pwcounter=? WHERE id = ? ", array($neuerwert,1))) {
          $updatedRows = $this->class_obj->rowCount();
          $this->meldung=" wurde erfolgreich ge&auml;ndert.\n";
        } else {
          $this->meldung = "Beim &auml;ndern gab es einen Fehler.\n";
        }
    }

  public function sqlcounter() {
    $counter = $this->class_obj->select("SELECT sqlcounter FROM sqlcounter WHERE id='1'");
    $this->sqlcounter = $counter[0]['sqlcounter'];
    return $this->sqlcounter ;
  }

  public function pwcounter() {
    $counter = $this->class_obj->select("SELECT pwcounter FROM pwcounter WHERE id='1'");
    $this->pwcounter = $counter[0]['pwcounter'];
    return $this->pwcounter ;
  }

  public function webcounter() {
    $counter = $this->class_obj->select("SELECT counter FROM counter WHERE id='1'");
    $this->counter = $counter[0]['counter'];
    $this->debug($this->counter);
    return $this->counter ;
  }

  public function update_webcounter() {
    $neuerwert = $this->webcounter() + 1;
    $this->class_obj->update("UPDATE counter SET counter=? WHERE id = ?", array($neuerwert, 1));
  }

  // ----------------------------------------------------------------------------

  private function select($werte, $name, $selected="", $default=0, $beschriftung="", $KeyOrVal=0) {
    echo "<select size=\"1\" name=\"$name\">\n";
    if (isset($default)AND ($default==1)) { echo "<option ";
      if($selected == 0 ) echo "selected";
      echo " value=\"0\">$beschriftung</option>\n";}
    foreach ($werte as $key => $val) {
      echo '<option ';
      if ($key == $selected) { echo " selected "; }
      echo " value=\"";
      $ausgabe = ($KeyOrVal ==0 ? $key : $val);
      echo $ausgabe;
      echo "\">".$val."</option>\n";
    }
    echo "</select>\n";
  }

  private function debug ($ausgabe="", $array=true) {
  	if ($ausgabe !="") {
  		if (isset($_SESSION['debug']) and ($_SESSION['debug'] == true)) {
  			if (is_string($ausgabe)) {
  				echo "<font color=\"#FF0000\">(" . htmlspecialchars($ausgabe, ENT_QUOTES, 'UTF-8') . ")</font><br>\n";
  			}
          if (is_array($ausgabe)) {
    			  if ($array) {
    				  echo "<pre>\n";
    				  echo htmlspecialchars(print_r($ausgabe, true), ENT_QUOTES, 'UTF-8');
    				  echo "</pre>\n";
    			  }
  				}
  		}
  	}
  }

// ----------------------------------------------------------------------------
// Klassen ende
}
?>
