<?php
date_default_timezone_set('Europe/Berlin');
ini_set("display_errors", false);
ini_set("log_errors", true);
error_reporting(E_ALL);
session_set_cookie_params(10800);
session_start();

header('X-Content-Type-Options: nosniff');
header('X-Frame-Options: DENY');
header('X-XSS-Protection: 1; mode=block');
header('Referrer-Policy: no-referrer');
header("Content-Security-Policy: default-src 'self'; script-src 'self' 'unsafe-inline'; style-src 'self' 'unsafe-inline'; img-src 'self' data:;");

// CSRF-Token generieren
if (!isset($_SESSION['csrf_token'])) {
    $_SESSION['csrf_token'] = bin2hex(random_bytes(32));
}

  // $_SESSION['debug'] = true;
  include 'variablen.php';

// INIT ---------------------------------------------------------------------------
// Datenbank initialisieren
require "class/PM.php";
switch ($_SERVER['DOCUMENT_ROOT'])	{
  case "/var/www/8080":
    $file = "../SQL-settings_Secnote.ini.php";
    $url = "secnote.eblok.de/index.php?id=";
  break;
  case "/home/wwwdev/Schreibtisch/CLOUD/WWW":
    $file = "SQL-settings_local.ini.php";
    $url = "http://192.168.3.10/secnote/".$config['version']."/index.php?id=";
  break;
  default:
    echo "Fehlende Server-Konfiguration!<br/>"; echo $_SERVER['DOCUMENT_ROOT']."<br/>";
  exit;
}
// Credentials werden temporaer in Session gespeichert fuer Database-Konstruktor
$_SESSION['SQL'] = parse_ini_file($file);
$config['URL']= $url;
// Root ausloggen
  if (isset($_GET['session']) and $_GET['session'] == "aus") $_SESSION['user'] = "user";

$PM = new PM("Database",".php");
// Credentials nach DB-Initialisierung aus Session entfernen
unset($_SESSION['SQL']);

$PM->config($config,$message);

// Route-Mapping
if (isset($_POST) or (isset($_GET))) {
  if (isset($_GET['id'])) {   $cont="anzeigen"; }
  if (isset($_GET['idd'])) {   $cont="anzeigen2"; }
}
?>
<!DOCTYPE html>
<html>
  <head>
    <meta name="viewport" content="width=device-width, initial-scale=1.0"/>
    <title>EBLOK's SecNote</title>
    <link rel="stylesheet" type="text/css" href="css/style.css" />
  </head>
  <body>
    <?php
    if (!isset($_SESSION['counter_ip'])) {
        $PM->update_webcounter();
        $_SESSION['counter_ip'] = true;
    }
    $counterstand = $PM->webcounter();
    ?>
    <div id="haupt">
      <h3>secnote.eblok.de</h3>
        <?php
        // Request-Routing
        if (isset($_REQUEST['cont']) or isset($cont)) {
        	if(!isset($cont)) $cont=$_REQUEST['cont'];
        	switch ($cont) {

        		case "home":
        			echo $message['anleitung'];
        		break;

        	case "eintragen":
        		if (isset($_POST['text_neu'])) {
        			if (!isset($_POST['csrf_token']) || !hash_equals($_SESSION['csrf_token'], $_POST['csrf_token'])) {
        				echo "Sicherheitsfehler: Ung&uuml;ltiges Formular-Token. Bitte erneut versuchen.";
        			} else {
        				$fehlversuche = isset($_POST['fehlversuche']) ? intval($_POST['fehlversuche']) : 0;
        				if ($fehlversuche < 0 || $fehlversuche > 3) { $fehlversuche = 0; }
        				$text = isset($_POST['text']) ? $_POST['text'] : '';
        				$passwort = isset($_POST['passwort']) ? $_POST['passwort'] : '';
        				$bild = null;
        				if ($config['bild_upload'] && isset($_FILES['bild']) && $_FILES['bild']['error'] === UPLOAD_ERR_OK) {
        				    $bild = $_FILES['bild'];
        				}
        				$meldung = $PM->eintragen($text, $passwort, $fehlversuche, $bild);
        			}
        		}
        	break;

        	case "check_older":
        		$meldung= $PM->del_older();
          break;
          ## Testweise alles zeigen
           case "eblokalleszeigen":
               $meldung= $PM->alle_zeigen();
           break;

        	case "statistik":
        		echo "<div id='statistik'>";
        		echo "<h4>Statistik</h4>";
        		echo "W (Web): " . $counterstand . "<br />";
        		echo "S (SQL): " . $PM->sqlcounter() . "<br />";
        		echo "P (Passwort): " . $PM->pwcounter() . "<br />";
        		echo "B (Bild): " . $PM->imgcounter() . "<br />";
        		echo "</div>";
        	break;

        	case "anzeigen":
        		$meldung= $PM->msg_zeigen($_GET['id']);
        	break;

        	case "anzeigen2":
        		$meldung= $PM->msg_zeigen2($_GET['idd']);
        	break;

        		default:
        			$schreiben = $PM->schreiben($message['anleitung']);
        		break;
        	}
        } else {
        		$schreiben = $PM->schreiben($message['anleitung']);
        	}
      ?>
      <span id="version">
        | <a id="version" href="index.php">eblok 2017 - <?php echo date("Y");?></a>
        | <a id="version" href="index.php"><?php echo "(V".$config['version'].")"; ?></a>
        | <a id="version" href="impressum.html">Impressum</a>
        | <a id="version" href="datenschutz.html">Datenschutz</a>
        |</a></span>
      </div>
  </body>
</html>
<?php $PM->class_obj->disconnect(); ?>
