<?php
class PM {

  public $class_obj;
  private $msg;
  private $config;
  private $timestamp;
  private $datum;
  private $uhrzeit;
  private $zeit;
  private $jahr;
  private $monat;
  private $tag;
  private $stunde;
  private $minute;
  private $sqlcounter;
  private $pwcounter;
  private $imgcounter;
  private $counter;
  private $text;
  private $code;
  private $meldung;

  // Konstruktor
  public function __construct ($class_needed,$file_ending) {
    // Die Klasse wird eingebunden
      include($class_needed.$file_ending);
    // Es wird eine Instanz der Klasse erzeugt, und "class_obj" zugewiesen
      $this->class_obj = new $class_needed;
      $this->debug($_POST);
      $this->debug($_GET);
  }

  public function config($config, $MSG) {
    $this->msg = $MSG;
    $this->config = $config;
    ### Zeitstempel
    date_default_timezone_set("Europe/Berlin");

    $this->timestamp = time();
    $this->datum = date("Y.m.d",$this->timestamp);
    $this->uhrzeit = date("H-i-s",$this->timestamp);
    $this->zeit 	= $this->datum."--".$this->uhrzeit;
    $this->jahr 	= substr($this->zeit,0,4);
    $this->monat 	= substr($this->zeit,4,2);
    $this->tag 	= substr($this->zeit,6,2);
    $this->stunde = substr($this->zeit,8,2);
    $this->minute = substr($this->zeit,10,2);
    $this->del_older();
  }

  public function schreiben($msg) {
    $typen=array("0"=>"0","1"=>"1","2"=>"2","3"=>"3", );
    echo "<div id=\"schreiben\">\n";
    echo "  <span id=\"text1\">$msg</span>\n";
    echo "  <form id=\"secnote-form\" method=\"post\" enctype=\"multipart/form-data\">\n";
    echo "    <textarea id=\"secnote-text\" name=\"text\" cols=\"40\" rows=\"10\"></textarea>\n<br/><br />\n";
    if ($this->config['bild_upload']) {
      echo "<label for=\"secnote-bild\">".$this->msg['bild_label']."</label><br />\n";
      echo "<input type=\"file\" name=\"bild\" id=\"secnote-bild\" accept=\"image/*\" /><br /><br />\n";
    }
    echo "    <input type=\"submit\" id=\"secnote-submit\" name=\"text_neu\" value=\"".$this->msg['link_erstellen']."\"><br /><br />\n";
    if ($this->config['passwort_funktion']) {
      echo "<hr />\n";
      echo "zus&auml;tzliche Optionen:<br /><br />\n";
      echo "<label for \"pw\">Passwort</label>  <input id=\"pw\" type=\"password\" name=\"passwort\" size=\"8\" />\n";
      echo "    <input id=\"check\" type=\"checkbox\" />\n";
      echo "<label for \"check\"> ".$this->msg['zeigen']."</label><br />\n";
      echo "<span id=\"passworthinweisSender\">".$this->msg['passworthinweisSender']."</span><br />\n";
      echo "<label for \"fehlversuche\">M&ouml;gliche Passwortfehlversuche des Empf&auml;nger erlauben.</label>\n";$this->select($typen, "fehlversuche",$this->config['Passwortfehlversuche']);
      echo "<script>\n";
      echo "	var check = document.getElementById(\"check\"),\n";
      echo "		pw = document.getElementById(\"pw\");\n";
      echo "	check.onclick = function() {\n";
      echo "		pw.type = this.checked ? \"text\" : \"password\";\n";
      echo "	};\n";
      echo "</script>\n";
    }
    echo "  </form>\n";
    echo "\n";
    echo "</div>\n";

    // Result container (hidden, shown by JS after successful creation)
    echo "<div id=\"secnote-result\" style=\"display:none;\">\n";
    echo "  <div id=\"gespeichert\">\n";
    echo "    ".$this->msg['gespeichert1']."\n";
    echo "    <b><span id=\"hinweis\"></span><br /><br /></b>\n";
    echo "    <div id=\"urlbox\">\n";
    echo "      <span id=\"url\"></span><br />\n";
    echo "    </div>\n";
    echo "    <div class=\"button_container\">\n";
    echo "      <button class=\"btn\" data-clipboard-target=\"#url\">\n";
    echo "        <img src=\"assets/clippy.svg\" alt=\"".$this->msg['clipboard']."\">\n";
    echo "      </button>\n";
    echo "    </div>\n";
    echo "    <br /><br />\n";
    echo "    <a href=\"index.php\">".$this->msg['link_weitere']."</a>\n";
    echo "  </div>\n";
    echo "</div>\n";
  }

  // --- API Methods ---

  public function api_eintragen() {
    // CSRF validation
    if (!isset($_POST['csrf_token']) || !hash_equals($_SESSION['csrf_token'], $_POST['csrf_token'])) {
      echo json_encode(array('success' => false, 'error' => 'CSRF-Token ungueltig.'));
      return;
    }

    $msg = isset($_POST['msg']) ? $_POST['msg'] : '';
    $img = isset($_POST['img']) ? $_POST['img'] : '';
    $passwort = isset($_POST['passwort']) ? intval($_POST['passwort']) : 0;
    $fehler = isset($_POST['fehler']) ? intval($_POST['fehler']) : 0;

    if ($fehler < 0 || $fehler > 3) { $fehler = 0; }

    // At least msg or img must be present
    if ($msg === '' && $img === '') {
      echo json_encode(array('success' => false, 'error' => $this->msg['eingabe_leer']));
      return;
    }

    $this->genCode($this->config['codelenght']);

    $arr = array();
    $arr[] = $this->code;
    $arr[] = $msg;
    $arr[] = $this->timestamp;
    $arr[] = "";
    $arr[] = $passwort;
    $arr[] = $fehler;
    $arr[] = ($img !== '') ? $img : null;

    if ($this->class_obj->insert("INSERT INTO nachrichten (rid, msg, datum, rdatum, passwort, fehler, img) VALUES (?,?,?,?,?,?,?)", $arr)) {
      $this->update_sqlcounter();
      if ($passwort == 1) {
        $this->update_pwcounter();
      }
      if ($img !== '') {
        $this->update_imgcounter();
      }
      echo json_encode(array(
        'success' => true,
        'id' => $this->code,
        'url' => $this->config['URL'] . $this->code
      ));
    } else {
      echo json_encode(array('success' => false, 'error' => 'Datenbankfehler.'));
    }
  }

  public function api_fetch($id) {
    $selected = $this->class_obj->select("SELECT id,rid,msg,passwort,fehler,img FROM nachrichten WHERE rid = ?", array($id));
    if (count($selected) === 0) {
      echo json_encode(array('found' => false));
      return;
    }
    $row = $selected[0];
    echo json_encode(array(
      'found' => true,
      'msg' => $row['msg'] !== null ? $row['msg'] : '',
      'img' => $row['img'] !== null ? $row['img'] : '',
      'passwort' => intval($row['passwort']),
      'fehler' => intval($row['fehler'])
    ));
  }

  public function api_delete() {
    if (!isset($_POST['csrf_token']) || !hash_equals($_SESSION['csrf_token'], $_POST['csrf_token'])) {
      echo json_encode(array('success' => false, 'error' => 'CSRF-Token ungueltig.'));
      return;
    }
    $id = isset($_POST['id']) ? $_POST['id'] : '';
    if ($id === '') {
      echo json_encode(array('success' => false));
      return;
    }
    $this->class_obj->delete("DELETE FROM nachrichten WHERE rid = ?", array($id));
    echo json_encode(array('success' => true));
  }

  public function api_attempt() {
    if (!isset($_POST['csrf_token']) || !hash_equals($_SESSION['csrf_token'], $_POST['csrf_token'])) {
      echo json_encode(array('success' => false, 'error' => 'CSRF-Token ungueltig.'));
      return;
    }
    $id = isset($_POST['id']) ? $_POST['id'] : '';
    if ($id === '') {
      echo json_encode(array('success' => false));
      return;
    }
    $selected = $this->class_obj->select("SELECT id,fehler FROM nachrichten WHERE rid = ?", array($id));
    if (count($selected) === 0) {
      echo json_encode(array('remaining' => 0, 'deleted' => true));
      return;
    }
    $row = $selected[0];
    $remaining = intval($row['fehler']) - 1;
    if ($remaining < 0) {
      // No attempts left, delete
      $this->class_obj->delete("DELETE FROM nachrichten WHERE id = ?", array($row['id']));
      echo json_encode(array('remaining' => 0, 'deleted' => true));
    } else {
      // Decrement
      $this->class_obj->update("UPDATE nachrichten SET fehler = ? WHERE id = ?", array($remaining, $row['id']));
      echo json_encode(array('remaining' => $remaining, 'deleted' => false));
    }
  }

  // --- Viewer HTML Shell ---

  public function viewer() {
    echo "<div id=\"viewer-container\">\n";
    echo "  <div id=\"viewer-loading\">".$this->msg['nachricht_laden']."</div>\n";
    echo "  <div id=\"viewer-password\" style=\"display:none;\"></div>\n";
    echo "  <div id=\"viewer-content\" style=\"display:none;\"></div>\n";
    echo "  <div id=\"viewer-error\" style=\"display:none;\"></div>\n";
    echo "</div>\n";
  }

  // --- Kept methods ---

  public function del_older() {
     $selected = $this->class_obj->select("SELECT id,rid,msg,datum,rdatum,passwort FROM nachrichten");
     $rowCount = $this->class_obj->rowCount();
     for ($i=0; $i < $rowCount; $i++) {
       if (count($selected) > 0) {
         if($selected[$i]['datum'] < strtotime("-".$this->config['userDelDays']." days")) {
           $this->class_obj->delete("DELETE FROM nachrichten WHERE id = ?", array($selected[$i]['id']));
         }
       }
     }
  }

  private function msg_link() {
     echo "<br /><br /><hr /><br /><a href=\"index.php\">".$this->msg['selbstNachricht']."</a><br /><br /><br />  ";
  }

  private	function genCode($characters) {
    $possible = '1234567890abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
    $this->code = '';
    $i = 0;
    while ($i < $characters) {
      $this->code .= $possible[random_int(0, strlen($possible)-1)];
      $i++;
    }
    return $this->code;
  }

  private function update_sqlcounter() {
    $neuerwert=0;
    $wert = $this->sqlcounter();
    $neuerwert = $wert + 1;
        if ($this->class_obj->update("UPDATE sqlcounter SET sqlcounter=? WHERE id = ? ", array($neuerwert,1))) {
          $updatedRows = $this->class_obj->rowCount();
          $this->meldung=" wurde erfolgreich ge&auml;ndert.\n";
        } else {
          $this->meldung = "Beim &auml;ndern gab es einen Fehler.\n";
        }
    }

  private function update_imgcounter() {
    $neuerwert=0;
    $wert = $this->imgcounter();
    $neuerwert = $wert + 1;
        if ($this->class_obj->update("UPDATE imgcounter SET imgcounter=? WHERE id = ? ", array($neuerwert,1))) {
          $updatedRows = $this->class_obj->rowCount();
          $this->meldung=" wurde erfolgreich ge&auml;ndert.\n";
        } else {
          $this->meldung = "Beim &auml;ndern gab es einen Fehler.\n";
        }
    }

  private function update_pwcounter() {
    $neuerwert=0;
    $wert = $this->pwcounter();
    $neuerwert = $wert + 1;
        if ($this->class_obj->update("UPDATE pwcounter SET pwcounter=? WHERE id = ? ", array($neuerwert,1))) {
          $updatedRows = $this->class_obj->rowCount();
          $this->meldung=" wurde erfolgreich ge&auml;ndert.\n";
        } else {
          $this->meldung = "Beim &auml;ndern gab es einen Fehler.\n";
        }
    }

  public function sqlcounter() {
    $counter = $this->class_obj->select("SELECT sqlcounter FROM sqlcounter WHERE id='1'");
    $this->sqlcounter = $counter[0]['sqlcounter'];
    return $this->sqlcounter ;
  }

  public function pwcounter() {
    $counter = $this->class_obj->select("SELECT pwcounter FROM pwcounter WHERE id='1'");
    $this->pwcounter = $counter[0]['pwcounter'];
    return $this->pwcounter ;
  }

  public function imgcounter() {
    $counter = $this->class_obj->select("SELECT imgcounter FROM imgcounter WHERE id='1'");
    $this->imgcounter = $counter[0]['imgcounter'];
    return $this->imgcounter ;
  }

  public function webcounter() {
    $counter = $this->class_obj->select("SELECT counter FROM counter WHERE id='1'");
    $this->counter = $counter[0]['counter'];
    $this->debug($this->counter);
    return $this->counter ;
  }

  public function update_webcounter() {
    $neuerwert = $this->webcounter() + 1;
    $this->class_obj->update("UPDATE counter SET counter=? WHERE id = ?", array($neuerwert, 1));
  }

  // ----------------------------------------------------------------------------

  private function select($werte, $name, $selected="", $default=0, $beschriftung="", $KeyOrVal=0) {
    echo "<select size=\"1\" name=\"$name\" id=\"secnote-fehler\">\n";
    if (isset($default)AND ($default==1)) { echo "<option ";
      if($selected == 0 ) echo "selected";
      echo " value=\"0\">$beschriftung</option>\n";}
    foreach ($werte as $key => $val) {
      echo '<option ';
      if ($key == $selected) { echo " selected "; }
      echo " value=\"";
      $ausgabe = ($KeyOrVal ==0 ? $key : $val);
      echo $ausgabe;
      echo "\">".$val."</option>\n";
    }
    echo "</select>\n";
  }

  private function debug ($ausgabe="", $array=true) {
  	if ($ausgabe !="") {
  		if (isset($_SESSION['debug']) and ($_SESSION['debug'] == true)) {
  			if (is_string($ausgabe)) {
  				echo "<font color=\"#FF0000\">(" . htmlspecialchars($ausgabe, ENT_QUOTES, 'UTF-8') . ")</font><br>\n";
  			}
          if (is_array($ausgabe)) {
    			  if ($array) {
    				  echo "<pre>\n";
    				  echo htmlspecialchars(print_r($ausgabe, true), ENT_QUOTES, 'UTF-8');
    				  echo "</pre>\n";
    			  }
  				}
  		}
  	}
  }

// ----------------------------------------------------------------------------
// Klassen ende
}
?>
