<?php
date_default_timezone_set('Europe/Berlin');
ini_set("display_errors", false);
ini_set("log_errors", true);
error_reporting(E_ALL);
session_set_cookie_params(10800);
session_start();

header('X-Content-Type-Options: nosniff');
header('X-Frame-Options: DENY');
header('X-XSS-Protection: 1; mode=block');
header('Referrer-Policy: no-referrer');
header("Content-Security-Policy: default-src 'self'; script-src 'self' 'unsafe-inline'; style-src 'self' 'unsafe-inline'; img-src 'self' data:;");

// CSRF-Token generieren
if (!isset($_SESSION['csrf_token'])) {
    $_SESSION['csrf_token'] = bin2hex(random_bytes(32));
}

  // $_SESSION['debug'] = true;
  include 'variablen.php';

// INIT ---------------------------------------------------------------------------
// Datenbank initialisieren
require "class/PM.php";
switch ($_SERVER['DOCUMENT_ROOT'])	{
  case "/var/www/8080":
    $file = "../SQL-settings_Secnote.ini.php";
    $url = "secnote.eblok.de/index.php?id=";
  break;
  case "/home/wwwdev/Schreibtisch/CLOUD/WWW":
    $file = "SQL-settings_local.ini.php";
    $url = "http://192.168.3.10/secnote/".$config['version']."/index.php?id=";
  break;
  default:
    echo "Fehlende Server-Konfiguration!<br/>"; echo $_SERVER['DOCUMENT_ROOT']."<br/>";
  exit;
}
// Credentials werden temporaer in Session gespeichert fuer Database-Konstruktor
$_SESSION['SQL'] = parse_ini_file($file);
$config['URL']= $url;
// Root ausloggen
  if (isset($_GET['session']) and $_GET['session'] == "aus") $_SESSION['user'] = "user";

$PM = new PM("Database",".php");
// Credentials nach DB-Initialisierung aus Session entfernen
unset($_SESSION['SQL']);

$PM->config($config,$message);

// Route-Mapping
if (isset($_GET['id'])) { $cont="anzeigen"; }

// --- API Routes (JSON, no HTML) ---
if (isset($_REQUEST['cont'])) {
  $apiCont = $_REQUEST['cont'];
  if (in_array($apiCont, array('api_create', 'api_fetch', 'api_delete', 'api_attempt'))) {
    header('Content-Type: application/json; charset=utf-8');
    switch ($apiCont) {
      case "api_create":
        $PM->api_eintragen();
      break;
      case "api_fetch":
        $id = isset($_GET['id']) ? $_GET['id'] : '';
        $PM->api_fetch($id);
      break;
      case "api_delete":
        $PM->api_delete();
      break;
      case "api_attempt":
        $PM->api_attempt();
      break;
    }
    $PM->class_obj->disconnect();
    exit;
  }
}
?>
<!DOCTYPE html>
<html>
  <head>
    <meta name="viewport" content="width=device-width, initial-scale=1.0"/>
    <title>EBLOK's SecNote</title>
    <link rel="stylesheet" type="text/css" href="css/style.css" />
  </head>
  <body>
    <?php
    if (!isset($_SESSION['counter_ip'])) {
        $PM->update_webcounter();
        $_SESSION['counter_ip'] = true;
    }
    $counterstand = $PM->webcounter();
    ?>
    <div id="haupt">
      <h3>secnote.eblok.de</h3>
        <?php
        // Request-Routing
        if (isset($_REQUEST['cont']) or isset($cont)) {
        	if(!isset($cont)) $cont=$_REQUEST['cont'];
        	switch ($cont) {

        		case "home":
        			echo $message['anleitung'];
        		break;

        	case "check_older":
        		$meldung= $PM->del_older();
          break;

        	case "statistik":
        		echo "<div id='statistik'>";
        		echo "<h4>Statistik</h4>";
        		echo "W (Web): " . $counterstand . "<br />";
        		echo "S (SQL): " . $PM->sqlcounter() . "<br />";
        		echo "P (Passwort): " . $PM->pwcounter() . "<br />";
        		echo "B (Bild): " . $PM->imgcounter() . "<br />";
        		echo "</div>";
        	break;

        	case "anzeigen":
        		$PM->viewer();
        	break;

        		default:
        			$schreiben = $PM->schreiben($message['anleitung']);
        		break;
        	}
        } else {
        		$schreiben = $PM->schreiben($message['anleitung']);
        	}
      ?>
      <span id="version">
        | <a id="version" href="index.php">eblok 2017 - <?php echo date("Y");?></a>
        | <a id="version" href="index.php"><?php echo "(V".$config['version'].")"; ?></a>
        | <a id="version" href="impressum.html">Impressum</a>
        | <a id="version" href="datenschutz.html">Datenschutz</a>
        |</a></span>
      </div>
    <script>
    window.SECNOTE_CONFIG = {
        csrfToken: "<?= htmlspecialchars($_SESSION['csrf_token'], ENT_QUOTES, 'UTF-8') ?>",
        baseUrl: "<?= htmlspecialchars($url, ENT_QUOTES, 'UTF-8') ?>",
        maxImageSize: <?= $config['max_bild_size'] ?>,
        messages: <?= json_encode($message, JSON_HEX_TAG | JSON_HEX_AMP | JSON_HEX_APOS | JSON_HEX_QUOT) ?>
    };
    </script>
    <script src="dist/clipboard.min.js"></script>
    <script src="dist/forge.min.js"></script>
    <script src="js/secnote-crypto.js"></script>
    <script src="js/secnote-app.js"></script>
  </body>
</html>
<?php $PM->class_obj->disconnect(); ?>
